/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl;

import io.atomix.raft.RaftCommittedEntryListener;
import io.atomix.raft.storage.log.IndexedRaftLogEntry;
import io.camunda.zeebe.broker.system.partitions.StateController;
import io.camunda.zeebe.broker.system.partitions.impl.RandomDuration;
import io.camunda.zeebe.engine.processing.streamprocessor.StreamProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.StreamProcessorMode;
import io.camunda.zeebe.logstreams.impl.Loggers;
import io.camunda.zeebe.snapshots.TransientSnapshot;
import io.camunda.zeebe.util.health.FailureListener;
import io.camunda.zeebe.util.health.HealthMonitorable;
import io.camunda.zeebe.util.health.HealthStatus;
import io.camunda.zeebe.util.sched.Actor;
import io.camunda.zeebe.util.sched.SchedulingHints;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import io.camunda.zeebe.util.sched.future.CompletableActorFuture;
import java.time.Duration;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BooleanSupplier;
import org.slf4j.Logger;

public final class AsyncSnapshotDirector
extends Actor
implements RaftCommittedEntryListener,
HealthMonitorable {
    public static final Duration MINIMUM_SNAPSHOT_PERIOD = Duration.ofMinutes(1L);
    private static final Logger LOG = Loggers.SNAPSHOT_LOGGER;
    private static final String LOG_MSG_WAIT_UNTIL_COMMITTED = "Finished taking temporary snapshot, need to wait until last written event position {} is committed, current commit position is {}. After that snapshot will be committed.";
    private static final String ERROR_MSG_ON_RESOLVE_PROCESSED_POS = "Unexpected error in resolving last processed position.";
    private static final String ERROR_MSG_ON_RESOLVE_WRITTEN_POS = "Unexpected error in resolving last written position.";
    private static final String ERROR_MSG_MOVE_SNAPSHOT = "Unexpected exception occurred on moving valid snapshot.";
    private final StateController stateController;
    private final Duration snapshotRate;
    private final String processorName;
    private final StreamProcessor streamProcessor;
    private final String actorName;
    private final Set<FailureListener> listeners = new HashSet<FailureListener>();
    private final BooleanSupplier isLastWrittenPositionCommitted;
    private Long lastWrittenEventPosition;
    private TransientSnapshot pendingSnapshot;
    private long lowerBoundSnapshotPosition;
    private boolean takingSnapshot;
    private boolean persistingSnapshot;
    private volatile HealthStatus healthStatus = HealthStatus.HEALTHY;
    private long commitPosition;
    private final int partitionId;

    private AsyncSnapshotDirector(int nodeId, int partitionId, StreamProcessor streamProcessor, StateController stateController, Duration snapshotRate, StreamProcessorMode streamProcessorMode) {
        this.streamProcessor = streamProcessor;
        this.stateController = stateController;
        this.processorName = streamProcessor.getName();
        this.snapshotRate = snapshotRate;
        this.partitionId = partitionId;
        this.actorName = AsyncSnapshotDirector.buildActorName((int)nodeId, (String)"SnapshotDirector", (int)this.partitionId);
        this.isLastWrittenPositionCommitted = streamProcessorMode == StreamProcessorMode.REPLAY ? () -> true : () -> this.lastWrittenEventPosition <= this.commitPosition;
    }

    protected Map<String, String> createContext() {
        Map context = super.createContext();
        context.put("partitionId", Integer.toString(this.partitionId));
        return context;
    }

    public String getName() {
        return this.actorName;
    }

    protected void onActorStarting() {
        this.actor.setSchedulingHints(SchedulingHints.ioBound());
        Duration firstSnapshotTime = RandomDuration.getRandomDurationMinuteBased(MINIMUM_SNAPSHOT_PERIOD, this.snapshotRate);
        this.actor.runDelayed(firstSnapshotTime, this::scheduleSnapshotOnRate);
        this.lastWrittenEventPosition = null;
    }

    public ActorFuture<Void> closeAsync() {
        if (this.actor.isClosed()) {
            return CompletableActorFuture.completed(null);
        }
        return super.closeAsync();
    }

    protected void handleFailure(Throwable failure) {
        LOG.error("No snapshot was taken due to failure in '{}'. Will try to take snapshot after snapshot period {}. {}", new Object[]{this.actorName, this.snapshotRate, failure});
        this.resetStateOnFailure();
        this.healthStatus = HealthStatus.UNHEALTHY;
        for (FailureListener listener : this.listeners) {
            listener.onFailure();
        }
    }

    public static AsyncSnapshotDirector ofReplayMode(int nodeId, int partitionId, StreamProcessor streamProcessor, StateController stateController, Duration snapshotRate) {
        return new AsyncSnapshotDirector(nodeId, partitionId, streamProcessor, stateController, snapshotRate, StreamProcessorMode.REPLAY);
    }

    public static AsyncSnapshotDirector ofProcessingMode(int nodeId, int partitionId, StreamProcessor streamProcessor, StateController stateController, Duration snapshotRate) {
        return new AsyncSnapshotDirector(nodeId, partitionId, streamProcessor, stateController, snapshotRate, StreamProcessorMode.PROCESSING);
    }

    private void scheduleSnapshotOnRate() {
        this.actor.runAtFixedRate(this.snapshotRate, this::prepareTakingSnapshot);
        this.prepareTakingSnapshot();
    }

    public void forceSnapshot() {
        this.actor.call(this::prepareTakingSnapshot);
    }

    public HealthStatus getHealthStatus() {
        return this.healthStatus;
    }

    public void addFailureListener(FailureListener listener) {
        this.actor.run(() -> this.listeners.add(listener));
    }

    public void removeFailureListener(FailureListener failureListener) {
        this.actor.run(() -> this.listeners.remove(failureListener));
    }

    private void prepareTakingSnapshot() {
        if (this.takingSnapshot) {
            return;
        }
        this.takingSnapshot = true;
        ActorFuture futureLastProcessedPosition = this.streamProcessor.getLastProcessedPositionAsync();
        this.actor.runOnCompletion(futureLastProcessedPosition, (lastProcessedPosition, error) -> {
            if (error == null) {
                if (lastProcessedPosition == -1L) {
                    LOG.debug("We will skip taking this snapshot, because we haven't processed something yet.");
                    this.takingSnapshot = false;
                    return;
                }
                this.lowerBoundSnapshotPosition = lastProcessedPosition;
                this.takeSnapshot();
            } else {
                LOG.error(ERROR_MSG_ON_RESOLVE_PROCESSED_POS, error);
                this.takingSnapshot = false;
            }
        });
    }

    private void takeSnapshot() {
        ActorFuture<Optional<TransientSnapshot>> transientSnapshotFuture = this.stateController.takeTransientSnapshot(this.lowerBoundSnapshotPosition);
        transientSnapshotFuture.onComplete((optionalTransientSnapshot, snapshotTakenError) -> {
            if (snapshotTakenError != null) {
                LOG.error("Could not take a snapshot for {}", (Object)this.processorName, snapshotTakenError);
                this.resetStateOnFailure();
                return;
            }
            if (optionalTransientSnapshot.isEmpty()) {
                this.takingSnapshot = false;
                return;
            }
            this.onTransientSnapshotTaken((TransientSnapshot)optionalTransientSnapshot.get());
        });
    }

    private void onTransientSnapshotTaken(TransientSnapshot transientSnapshot) {
        this.pendingSnapshot = transientSnapshot;
        this.onRecovered();
        ActorFuture lastWrittenPosition = this.streamProcessor.getLastWrittenPositionAsync();
        this.actor.runOnCompletion(lastWrittenPosition, this::onLastWrittenPositionReceived);
    }

    private void onLastWrittenPositionReceived(Long endPosition, Throwable error) {
        if (error == null) {
            LOG.info(LOG_MSG_WAIT_UNTIL_COMMITTED, (Object)endPosition, (Object)this.commitPosition);
            this.lastWrittenEventPosition = endPosition;
            this.persistingSnapshot = false;
            this.persistSnapshotIfLastWrittenPositionCommitted();
        } else {
            this.resetStateOnFailure();
            LOG.error(ERROR_MSG_ON_RESOLVE_WRITTEN_POS, error);
        }
    }

    private void onRecovered() {
        if (this.healthStatus != HealthStatus.HEALTHY) {
            this.healthStatus = HealthStatus.HEALTHY;
            this.listeners.forEach(FailureListener::onRecovered);
        }
    }

    public void onCommit(IndexedRaftLogEntry indexedRaftLogEntry) {
        if (indexedRaftLogEntry.isApplicationEntry()) {
            long committedPosition = indexedRaftLogEntry.getApplicationEntry().highestPosition();
            this.newPositionCommitted(committedPosition);
        }
    }

    public void newPositionCommitted(long currentCommitPosition) {
        this.actor.run(() -> {
            this.commitPosition = currentCommitPosition;
            this.persistSnapshotIfLastWrittenPositionCommitted();
        });
    }

    private void persistSnapshotIfLastWrittenPositionCommitted() {
        if (this.pendingSnapshot != null && this.lastWrittenEventPosition != null && this.isLastWrittenPositionCommitted.getAsBoolean() && !this.persistingSnapshot) {
            this.persistingSnapshot = true;
            LOG.debug("Current commit position {} >= {}, committing snapshot {}.", new Object[]{this.commitPosition, this.lastWrittenEventPosition, this.pendingSnapshot});
            ActorFuture snapshotPersistFuture = this.pendingSnapshot.persist();
            snapshotPersistFuture.onComplete((snapshot, persistError) -> {
                if (persistError != null) {
                    LOG.error(ERROR_MSG_MOVE_SNAPSHOT, persistError);
                }
                this.lastWrittenEventPosition = null;
                this.takingSnapshot = false;
                this.pendingSnapshot = null;
                this.persistingSnapshot = false;
            });
        }
    }

    private void resetStateOnFailure() {
        this.lastWrittenEventPosition = null;
        this.takingSnapshot = false;
        if (this.pendingSnapshot != null) {
            this.pendingSnapshot.abort();
            this.pendingSnapshot = null;
        }
    }
}

