/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl;

import io.atomix.raft.RaftServer;
import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.system.partitions.PartitionStartupAndTransitionContextImpl;
import io.camunda.zeebe.broker.system.partitions.PartitionStep;
import io.camunda.zeebe.broker.system.partitions.PartitionTransition;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionContext;
import io.camunda.zeebe.util.exception.UnrecoverableException;
import io.camunda.zeebe.util.sched.ConcurrencyControl;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import io.camunda.zeebe.util.sched.future.CompletableActorFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;

public class PartitionTransitionImpl
implements PartitionTransition {
    private static final Logger LOG = Loggers.SYSTEM_LOGGER;
    private static final List<PartitionStep> EMPTY_LIST = Collections.emptyList();
    private static final int INACTIVE_TERM = -1;
    private final PartitionStartupAndTransitionContextImpl context;
    private final List<PartitionStep> leaderSteps;
    private final List<PartitionStep> followerSteps;
    private final List<PartitionStep> openedSteps = new ArrayList<PartitionStep>();
    private CompletableActorFuture<Void> currentTransition = CompletableActorFuture.completed(null);

    public PartitionTransitionImpl(PartitionStartupAndTransitionContextImpl context, List<PartitionStep> leaderSteps, List<PartitionStep> followerSteps) {
        this.context = context;
        this.leaderSteps = leaderSteps;
        this.followerSteps = followerSteps;
    }

    @Override
    public ActorFuture<Void> toFollower(long currentTerm) {
        return this.enqueueTransition(currentTerm, RaftServer.Role.FOLLOWER, this.followerSteps);
    }

    @Override
    public ActorFuture<Void> toLeader(long currentTerm) {
        return this.enqueueTransition(currentTerm, RaftServer.Role.LEADER, this.leaderSteps);
    }

    @Override
    public ActorFuture<Void> toInactive() {
        return this.enqueueTransition(-1L, RaftServer.Role.INACTIVE, EMPTY_LIST);
    }

    @Override
    public void setConcurrencyControl(ConcurrencyControl concurrencyControl) {
    }

    @Override
    public void updateTransitionContext(PartitionTransitionContext transitionContext) {
    }

    private ActorFuture<Void> enqueueTransition(long currentTerm, RaftServer.Role currentRole, List<PartitionStep> partitionStepList) {
        CompletableActorFuture nextTransitionFuture = new CompletableActorFuture();
        CompletableActorFuture<Void> nextCurrentTransition = this.currentTransition;
        this.currentTransition = nextTransitionFuture;
        nextCurrentTransition.onComplete((nothing, err) -> this.transition(currentTerm, currentRole, (CompletableActorFuture<Void>)nextTransitionFuture, partitionStepList));
        return nextTransitionFuture;
    }

    private void transition(long currentTerm, RaftServer.Role currentRole, CompletableActorFuture<Void> future, List<PartitionStep> steps) {
        this.context.setCurrentRole(currentRole);
        this.context.setCurrentTerm(currentTerm);
        this.closePartition().onComplete((nothing, err) -> {
            if (err instanceof UnrecoverableException) {
                future.completeExceptionally(err);
            } else {
                this.installPartition(future, new ArrayList<PartitionStep>(steps));
            }
        });
    }

    private void installPartition(CompletableActorFuture<Void> future, List<PartitionStep> steps) {
        if (steps.isEmpty()) {
            LOG.debug("Partition {} transition complete, installed {} resources!", (Object)this.context.getPartitionId(), (Object)this.openedSteps.size());
            future.complete(null);
            return;
        }
        PartitionStep step = steps.remove(0);
        try {
            step.open(this.context).onComplete((value, err) -> {
                if (err != null) {
                    LOG.error("Expected to open step '{}' but failed with", (Object)step.getName(), err);
                    this.tryCloseStep(step);
                    future.completeExceptionally(err);
                } else {
                    this.openedSteps.add(step);
                    this.installPartition(future, steps);
                }
            });
        }
        catch (Exception e) {
            LOG.error("Expected to open step '{}' but failed with", (Object)step.getName(), (Object)e);
            this.tryCloseStep(step);
            future.completeExceptionally((Throwable)e);
        }
    }

    private void tryCloseStep(PartitionStep step) {
        try {
            step.close(this.context);
        }
        catch (Exception e) {
            LOG.debug("Couldn't close partition step '{}' that failed to open", (Object)step.getName(), (Object)e);
        }
    }

    private CompletableActorFuture<Void> closePartition() {
        ArrayList<PartitionStep> closingSteps = new ArrayList<PartitionStep>(this.openedSteps);
        Collections.reverse(closingSteps);
        return this.closeSteps(closingSteps);
    }

    private CompletableActorFuture<Void> closeSteps(List<PartitionStep> steps) {
        CompletableActorFuture closingPartitionFuture = new CompletableActorFuture();
        this.closeNextStep((CompletableActorFuture<Void>)closingPartitionFuture, steps, null);
        return closingPartitionFuture;
    }

    private void closeNextStep(CompletableActorFuture<Void> future, List<PartitionStep> steps, Throwable throwable) {
        if (steps.isEmpty()) {
            LOG.debug("Partition {} closed all previous open resources, before transitioning.", (Object)this.context.getPartitionId());
            if (throwable == null) {
                future.complete(null);
            } else {
                future.completeExceptionally(throwable);
            }
            return;
        }
        PartitionStep step = steps.remove(0);
        LOG.debug("Closing Zeebe-Partition-{}: {}", (Object)this.context.getPartitionId(), (Object)step.getName());
        try {
            step.close(this.context).onComplete((v, closingError) -> {
                if (closingError == null) {
                    LOG.debug("Closing Zeebe-Partition-{}: {} closed successfully", (Object)this.context.getPartitionId(), (Object)step.getName());
                } else {
                    LOG.error("Closing Zeebe-Partition-{}: {} failed to close. Closing remaining steps", new Object[]{this.context.getPartitionId(), step.getName(), closingError});
                }
                this.openedSteps.remove(step);
                this.closeNextStep(future, steps, throwable != null ? throwable : closingError);
            });
        }
        catch (Exception e) {
            LOG.error("Zeebe-Partition-{}: Step {} failed to close with uncaught exception", new Object[]{this.context.getPartitionId(), step.getName(), e});
            this.openedSteps.remove(step);
            this.closeNextStep(future, steps, e);
        }
    }
}

