/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl;

import io.atomix.raft.RaftServer;
import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionStep;
import io.camunda.zeebe.util.sched.ConcurrencyControl;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;

final class PartitionTransitionProcess {
    private static final Logger LOG = Loggers.SYSTEM_LOGGER;
    private final List<PartitionTransitionStep> pendingSteps;
    private final Deque<PartitionTransitionStep> stepsToCleanUp = new ArrayDeque<PartitionTransitionStep>();
    private final ConcurrencyControl concurrencyControl;
    private final PartitionTransitionContext context;
    private final long term;
    private final RaftServer.Role role;
    private boolean cancelRequested = false;

    PartitionTransitionProcess(List<PartitionTransitionStep> pendingSteps, ConcurrencyControl concurrencyControl, PartitionTransitionContext context, long term, RaftServer.Role role) {
        this.pendingSteps = new ArrayList<PartitionTransitionStep>((Collection)Objects.requireNonNull(pendingSteps));
        pendingSteps.forEach(this.stepsToCleanUp::push);
        this.concurrencyControl = Objects.requireNonNull(concurrencyControl);
        this.context = Objects.requireNonNull(context);
        this.term = term;
        this.role = Objects.requireNonNull(role);
    }

    void start(ActorFuture<Void> future) {
        LOG.info(String.format("Transition to %s on term %d starting", this.role, this.term));
        if (this.pendingSteps.isEmpty()) {
            LOG.info("No steps defined for transition");
            future.complete(null);
            return;
        }
        this.proceedWithTransition(future);
    }

    private void proceedWithTransition(ActorFuture<Void> future) {
        if (this.cancelRequested) {
            LOG.info(String.format("Cancelling transition to %s on term %d", this.role, this.term));
            future.complete(null);
            return;
        }
        this.concurrencyControl.run(() -> {
            PartitionTransitionStep nextStep = this.pendingSteps.remove(0);
            LOG.info(String.format("Transition to %s on term %d - executing %s", this.role, this.term, nextStep.getName()));
            try {
                nextStep.transitionTo(this.context, this.term, this.role).onComplete((ok, error) -> this.onStepCompletion(future, (Throwable)error));
            }
            catch (Exception e) {
                future.completeExceptionally((Throwable)e);
            }
        });
    }

    private void onStepCompletion(ActorFuture<Void> future, Throwable error) {
        if (error != null) {
            LOG.error(error.getMessage(), error);
            future.completeExceptionally(error);
            return;
        }
        if (this.pendingSteps.isEmpty()) {
            LOG.info(String.format("Transition to %s on term %d completed", this.role, this.term));
            future.complete(null);
            return;
        }
        this.proceedWithTransition(future);
    }

    ActorFuture<Void> cleanup(long newTerm, RaftServer.Role newRole) {
        LOG.info(String.format("Preparation before transition to %s on term %d starting (in preparation for new transition to %s)", this.role, this.term, newRole));
        ActorFuture cleanupFuture = this.concurrencyControl.createFuture();
        if (this.stepsToCleanUp.isEmpty()) {
            LOG.info("No steps to clean up");
            cleanupFuture.complete(null);
        } else {
            this.proceedWithCleanup((ActorFuture<Void>)cleanupFuture, newTerm, newRole);
        }
        return cleanupFuture;
    }

    private void proceedWithCleanup(ActorFuture<Void> future, long newTerm, RaftServer.Role newRole) {
        this.concurrencyControl.run(() -> {
            PartitionTransitionStep nextCleanupStep = this.stepsToCleanUp.pop();
            LOG.info(String.format("Preparation before transition to %s on term %d - executing %s", this.role, this.term, nextCleanupStep.getName()));
            try {
                nextCleanupStep.prepareTransition(this.context, newTerm, newRole).onComplete((ok, error) -> this.onCleanupStepCompletion(future, (Throwable)error, newTerm, newRole));
            }
            catch (Exception e) {
                future.completeExceptionally((Throwable)e);
            }
        });
    }

    private void onCleanupStepCompletion(ActorFuture<Void> future, Throwable error, long newTerm, RaftServer.Role newRole) {
        if (error != null) {
            LOG.error(error.getMessage(), error);
            future.completeExceptionally(error);
            return;
        }
        if (this.stepsToCleanUp.isEmpty()) {
            LOG.info(String.format("Preparation before transition to %s on term %d completed", this.role, this.term));
            future.complete(null);
            return;
        }
        this.proceedWithCleanup(future, newTerm, newRole);
    }

    void cancel() {
        LOG.info(String.format("Received cancel signal for transition to %s on term %d", this.role, this.term));
        this.cancelRequested = true;
    }
}

