/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl.steps;

import io.atomix.raft.RaftCommitListener;
import io.atomix.raft.RaftServer;
import io.atomix.raft.partition.impl.RaftPartitionServer;
import io.atomix.raft.zeebe.ZeebeLogAppender;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionStep;
import io.camunda.zeebe.broker.system.partitions.impl.RecoverablePartitionTransitionException;
import io.camunda.zeebe.logstreams.storage.atomix.AtomixLogStorage;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import io.camunda.zeebe.util.sched.future.CompletableActorFuture;
import java.nio.ByteBuffer;
import java.util.Optional;

public final class LogStoragePartitionTransitionStep
implements PartitionTransitionStep {
    private static final String WRONG_TERM_ERROR_MSG = "Expected that current term '%d' is same as raft term '%d', but was not. Failing installation of 'LogStoragePartitionStep' on partition %d.";

    @Override
    public ActorFuture<Void> prepareTransition(PartitionTransitionContext context, long term, RaftServer.Role targetRole) {
        AtomixLogStorage logStorage = context.getLogStorage();
        if (logStorage != null && (this.shouldInstallOnTransition(targetRole, context.getCurrentRole()) || targetRole == RaftServer.Role.INACTIVE)) {
            context.getRaftPartition().getServer().removeCommitListener((RaftCommitListener)logStorage);
            context.setLogStorage(null);
        }
        return CompletableActorFuture.completed(null);
    }

    @Override
    public ActorFuture<Void> transitionTo(PartitionTransitionContext context, long term, RaftServer.Role targetRole) {
        if (this.shouldInstallOnTransition(targetRole, context.getCurrentRole()) || context.getLogStorage() == null && targetRole != RaftServer.Role.INACTIVE) {
            CompletableActorFuture openFuture = new CompletableActorFuture();
            Either<Exception, AtomixLogStorage> logStorageOrException = this.buildAtomixLogStorage(context, term, targetRole);
            if (logStorageOrException.isRight()) {
                AtomixLogStorage logStorage = (AtomixLogStorage)logStorageOrException.get();
                context.setLogStorage(logStorage);
                context.getRaftPartition().getServer().addCommitListener((RaftCommitListener)logStorage);
                openFuture.complete(null);
            } else {
                openFuture.completeExceptionally((Throwable)logStorageOrException.getLeft());
            }
            return openFuture;
        }
        return CompletableActorFuture.completed(null);
    }

    @Override
    public String getName() {
        return "LogStorage";
    }

    private boolean shouldInstallOnTransition(RaftServer.Role newRole, RaftServer.Role currentRole) {
        return newRole == RaftServer.Role.LEADER || newRole == RaftServer.Role.FOLLOWER && currentRole != RaftServer.Role.CANDIDATE || newRole == RaftServer.Role.CANDIDATE && currentRole != RaftServer.Role.FOLLOWER;
    }

    private Either<Exception, AtomixLogStorage> buildAtomixLogStorage(PartitionTransitionContext context, long targetTerm, RaftServer.Role targetRole) {
        RaftPartitionServer server = context.getRaftPartition().getServer();
        if (targetRole == RaftServer.Role.LEADER) {
            return this.createWritableLogStorage(context, server, targetTerm);
        }
        return this.createReadOnlyStorage(server);
    }

    private Either<Exception, AtomixLogStorage> createReadOnlyStorage(RaftPartitionServer server) {
        return Either.right((Object)new AtomixLogStorage(() -> ((RaftPartitionServer)server).openReader(), (ZeebeLogAppender)new LogAppenderForReadOnlyStorage()));
    }

    private Either<Exception, AtomixLogStorage> createWritableLogStorage(PartitionTransitionContext context, RaftPartitionServer server, long targetTerm) {
        Optional appenderOptional = server.getAppender();
        return appenderOptional.map(logAppender -> this.checkAndCreateAtomixLogStorage(context, server, (ZeebeLogAppender)logAppender, targetTerm)).orElseGet(() -> Either.left((Object)new IllegalStateException("Not leader of partition " + context.getPartitionId())));
    }

    private Either<Exception, AtomixLogStorage> checkAndCreateAtomixLogStorage(PartitionTransitionContext context, RaftPartitionServer server, ZeebeLogAppender logAppender, long targetTerm) {
        long raftTerm = server.getTerm();
        if (raftTerm != targetTerm) {
            return Either.left((Object)new LogStorageTermMissmatchException(targetTerm, raftTerm, context.getPartitionId()));
        }
        AtomixLogStorage logStorage = AtomixLogStorage.ofPartition(() -> ((RaftPartitionServer)server).openReader(), (ZeebeLogAppender)logAppender);
        return Either.right((Object)logStorage);
    }

    public static final class LogStorageTermMissmatchException
    extends RecoverablePartitionTransitionException {
        private LogStorageTermMissmatchException(long expectedTerm, long actualTerm, int partitionId) {
            super(String.format(LogStoragePartitionTransitionStep.WRONG_TERM_ERROR_MSG, expectedTerm, actualTerm, partitionId));
        }
    }

    private static class LogAppenderForReadOnlyStorage
    implements ZeebeLogAppender {
        private LogAppenderForReadOnlyStorage() {
        }

        public void appendEntry(long lowestPosition, long highestPosition, ByteBuffer data, ZeebeLogAppender.AppendListener appendListener) {
            throw new UnsupportedOperationException(String.format("Expect to append entry (positions %d - %d), but was in Follower role. Followers must not append entries to the log storage", lowestPosition, highestPosition));
        }
    }
}

