/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.bootstrap;

import io.atomix.cluster.AtomixCluster;
import io.camunda.zeebe.broker.bootstrap.AbstractBrokerStartupStep;
import io.camunda.zeebe.broker.bootstrap.BrokerStartupContext;
import io.camunda.zeebe.broker.clustering.AtomixClusterFactory;
import io.camunda.zeebe.broker.clustering.ClusterServicesImpl;
import io.camunda.zeebe.util.sched.ConcurrencyControl;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import java.util.concurrent.CompletableFuture;

final class ClusterServicesCreationStep
extends AbstractBrokerStartupStep {
    ClusterServicesCreationStep() {
    }

    @Override
    void startupInternal(BrokerStartupContext brokerStartupContext, ConcurrencyControl concurrencyControl, ActorFuture<BrokerStartupContext> startupFuture) {
        AtomixCluster atomix = AtomixClusterFactory.fromConfiguration(brokerStartupContext.getBrokerConfiguration());
        ClusterServicesImpl clusterServices = new ClusterServicesImpl(atomix);
        brokerStartupContext.setClusterServices(clusterServices);
        startupFuture.complete((Object)brokerStartupContext);
    }

    @Override
    void shutdownInternal(BrokerStartupContext brokerShutdownContext, ConcurrencyControl concurrencyControl, ActorFuture<BrokerStartupContext> shutdownFuture) {
        ClusterServicesImpl clusterServices = brokerShutdownContext.getClusterServices();
        if (clusterServices == null) {
            shutdownFuture.complete((Object)brokerShutdownContext);
            return;
        }
        CompletableFuture<Void> stopFuture = clusterServices.stop();
        stopFuture.whenComplete((ok, error) -> {
            if (error != null) {
                shutdownFuture.completeExceptionally(error);
            } else {
                concurrencyControl.run(() -> {
                    brokerShutdownContext.setClusterServices(null);
                    shutdownFuture.complete((Object)brokerShutdownContext);
                });
            }
        });
    }

    public String getName() {
        return "Cluster Services (Creation)";
    }
}

