/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl.steps;

import io.camunda.zeebe.broker.system.partitions.PartitionStartupAndTransitionContextImpl;
import io.camunda.zeebe.broker.system.partitions.PartitionStep;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import io.camunda.zeebe.util.sched.future.CompletableActorFuture;

public class ZeebeDbPartitionStep
implements PartitionStep {
    private static final String RECOVER_FAILED_ERROR_MSG = "Unexpected error occurred while recovering snapshot controller during leader partition install for partition %d";

    @Override
    public ActorFuture<Void> open(PartitionStartupAndTransitionContextImpl context) {
        CompletableActorFuture openFuture = new CompletableActorFuture();
        this.recoverDb(context, (CompletableActorFuture<Void>)openFuture);
        return openFuture;
    }

    @Override
    public ActorFuture<Void> close(PartitionStartupAndTransitionContextImpl context) {
        context.setZeebeDb((ZeebeDb)null);
        try {
            context.getStateController().closeDb();
        }
        catch (Exception e) {
            return CompletableActorFuture.completedExceptionally((Throwable)e);
        }
        return CompletableActorFuture.completed(null);
    }

    @Override
    public String getName() {
        return "ZeebeDb";
    }

    private void recoverDb(PartitionTransitionContext context, CompletableActorFuture<Void> openFuture) {
        ActorFuture<ZeebeDb> recoverFuture = context.getStateController().recover();
        recoverFuture.onComplete((zeebeDb, error) -> {
            if (error != null) {
                openFuture.completeExceptionally((Throwable)new IllegalStateException(String.format(RECOVER_FAILED_ERROR_MSG, context.getPartitionId()), (Throwable)error));
            } else {
                context.setZeebeDb((ZeebeDb)zeebeDb);
                openFuture.complete(null);
            }
        });
    }
}

