/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.transport.commandapi;

import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.system.configuration.QueryApiCfg;
import io.camunda.zeebe.broker.transport.commandapi.ErrorResponseWriter;
import io.camunda.zeebe.broker.transport.commandapi.QueryResponseWriter;
import io.camunda.zeebe.engine.state.QueryService;
import io.camunda.zeebe.protocol.record.ErrorCode;
import io.camunda.zeebe.protocol.record.ExecuteQueryRequestDecoder;
import io.camunda.zeebe.protocol.record.MessageHeaderDecoder;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.transport.RequestHandler;
import io.camunda.zeebe.transport.ServerOutput;
import io.camunda.zeebe.util.sched.Actor;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.agrona.DirectBuffer;
import org.agrona.collections.Int2ObjectHashMap;

@Deprecated(forRemoval=true, since="1.2.0")
public final class QueryApiRequestHandler
extends Actor
implements RequestHandler {
    private static final Set<ValueType> ACCEPTED_VALUE_TYPES = EnumSet.of(ValueType.PROCESS, ValueType.PROCESS_INSTANCE, ValueType.JOB);
    private final Map<Integer, QueryService> queryServicePerPartition = new Int2ObjectHashMap();
    private final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    private final ExecuteQueryRequestDecoder messageDecoder = new ExecuteQueryRequestDecoder();
    private final ErrorResponseWriter errorResponseWriter = new ErrorResponseWriter();
    private final QueryResponseWriter queryResponseWriter = new QueryResponseWriter();
    private final QueryApiCfg config;
    private final String actorName;

    public QueryApiRequestHandler(QueryApiCfg config, int nodeId) {
        this.config = config;
        this.actorName = QueryApiRequestHandler.buildActorName((int)nodeId, (String)"QueryApi");
    }

    public String getName() {
        return this.actorName;
    }

    protected void onActorClosing() {
        this.queryServicePerPartition.clear();
    }

    public void addPartition(int partitionId, QueryService queryService) {
        this.actor.run(() -> this.queryServicePerPartition.put(partitionId, queryService));
    }

    public void removePartition(int partitionId) {
        this.actor.run(() -> this.queryServicePerPartition.remove(partitionId));
    }

    public void onRequest(ServerOutput serverOutput, int partitionId, long requestId, DirectBuffer buffer, int offset, int length) {
        this.actor.run(() -> {
            try {
                this.handleRequest(serverOutput, partitionId, requestId, buffer, offset);
            }
            catch (Exception e) {
                Loggers.TRANSPORT_LOGGER.error("Failed to handle query on partition {}", (Object)partitionId, (Object)e);
                this.errorResponseWriter.internalError("Failed to handle query due to internal error; see the broker logs for more", new Object[0]).tryWriteResponse(serverOutput, partitionId, requestId);
            }
        });
    }

    private void handleRequest(ServerOutput serverOutput, int partitionId, long requestId, DirectBuffer buffer, int offset) {
        if (!this.config.isEnabled()) {
            this.errorResponseWriter.errorCode(ErrorCode.UNSUPPORTED_MESSAGE).errorMessage("Failed to handle query as the query API is disabled; did you configure zeebe.broker.experimental.queryapi.enabled?").tryWriteResponse(serverOutput, partitionId, requestId);
            return;
        }
        if (!this.decodeMessage(serverOutput, partitionId, requestId, buffer, offset)) {
            return;
        }
        QueryService queryService = this.queryServicePerPartition.get(partitionId);
        if (queryService == null) {
            this.errorResponseWriter.partitionLeaderMismatch(partitionId).tryWriteResponse(serverOutput, partitionId, requestId);
            return;
        }
        try {
            this.handleQuery(serverOutput, partitionId, requestId, queryService);
        }
        catch (QueryService.ClosedServiceException e) {
            Loggers.TRANSPORT_LOGGER.debug("Failed to handle query on partition {} as the query service was closed concurrently", (Object)partitionId, (Object)e);
            this.errorResponseWriter.partitionLeaderMismatch(partitionId).tryWriteResponse(serverOutput, partitionId, requestId);
        }
    }

    private void handleQuery(ServerOutput serverOutput, int partitionId, long requestId, QueryService queryService) {
        Optional bpmnProcessId;
        long key = this.messageDecoder.key();
        switch (this.messageDecoder.valueType()) {
            case PROCESS: {
                bpmnProcessId = queryService.getBpmnProcessIdForProcess(key);
                break;
            }
            case PROCESS_INSTANCE: {
                bpmnProcessId = queryService.getBpmnProcessIdForProcessInstance(key);
                break;
            }
            case JOB: {
                bpmnProcessId = queryService.getBpmnProcessIdForJob(key);
                break;
            }
            default: {
                this.failOnInvalidValueType(serverOutput, partitionId, requestId);
                return;
            }
        }
        if (bpmnProcessId.isEmpty()) {
            this.failOnResourceNotFound(serverOutput, partitionId, requestId, key);
            return;
        }
        this.queryResponseWriter.bpmnProcessId((DirectBuffer)bpmnProcessId.get()).tryWriteResponse(serverOutput, partitionId, requestId);
    }

    private boolean decodeMessage(ServerOutput serverOutput, int partitionId, long requestId, DirectBuffer buffer, int offset) {
        if (this.decodeMessageHeader(serverOutput, partitionId, requestId, buffer, offset)) {
            return false;
        }
        this.messageDecoder.wrap(buffer, offset + this.headerDecoder.encodedLength(), this.headerDecoder.blockLength(), this.headerDecoder.version());
        return true;
    }

    private boolean decodeMessageHeader(ServerOutput serverOutput, int partitionId, long requestId, DirectBuffer buffer, int offset) {
        this.headerDecoder.wrap(buffer, offset);
        int templateId = this.headerDecoder.templateId();
        int clientVersion = this.headerDecoder.version();
        if (clientVersion > 3) {
            this.errorResponseWriter.invalidClientVersion(3, clientVersion).tryWriteResponse(serverOutput, partitionId, requestId);
            return true;
        }
        if (templateId != 30) {
            this.errorResponseWriter.invalidMessageTemplate(templateId, 30).tryWriteResponse(serverOutput, partitionId, requestId);
            return true;
        }
        return false;
    }

    private void failOnResourceNotFound(ServerOutput serverOutput, int partitionId, long requestId, long key) {
        this.errorResponseWriter.errorCode(ErrorCode.PROCESS_NOT_FOUND).errorMessage("Expected to find the process ID for resource of type %s with key %d, but no such resource was found", this.messageDecoder.valueType(), key).tryWriteResponse(serverOutput, partitionId, requestId);
    }

    private void failOnInvalidValueType(ServerOutput serverOutput, int partitionId, long requestId) {
        this.errorResponseWriter.internalError("Expected to handle query with value type of %s, but was %s", ACCEPTED_VALUE_TYPES, this.messageDecoder.valueType()).tryWriteResponse(serverOutput, partitionId, requestId);
    }
}

