/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.journal.file;

import java.nio.ByteBuffer;

public final class FrameUtil {
    private static final byte VERSION = 1;
    private static final byte IGNORE = 0;
    private static final int LENGTH = 1;

    private FrameUtil() {
    }

    public static void writeVersion(ByteBuffer buffer, int offset) {
        FrameUtil.write(buffer, offset, (byte)1);
    }

    public static void markAsIgnored(ByteBuffer buffer, int offset) {
        FrameUtil.write(buffer, offset, (byte)0);
    }

    public static int readVersion(ByteBuffer buffer) {
        return buffer.get();
    }

    public static boolean hasValidVersion(ByteBuffer buffer) {
        if (buffer.capacity() < buffer.position() + 1) {
            return false;
        }
        return buffer.get(buffer.position()) != 0;
    }

    public static int getLength() {
        return 1;
    }

    private static void write(ByteBuffer buffer, int offset, byte value) {
        buffer.put(offset, value);
    }
}

