/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util;

import io.camunda.zeebe.util.Loggers;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.agrona.SystemUtil;
import org.slf4j.Logger;

public final class FileUtil {
    private static final Logger LOG = Loggers.FILE_LOGGER;

    private FileUtil() {
    }

    public static void flush(Path path) throws IOException {
        try (FileChannel channel = FileChannel.open(path, StandardOpenOption.READ);){
            channel.force(true);
        }
    }

    public static void flushDirectory(Path path) throws IOException {
        if (SystemUtil.isWindows()) {
            return;
        }
        FileUtil.flush(path);
    }

    public static void moveDurably(Path source, Path target, CopyOption ... options) throws IOException {
        Files.move(source, target, options);
        FileUtil.flushDirectory(target.getParent());
    }

    public static void deleteFolder(String path) throws IOException {
        Path directory = Paths.get(path, new String[0]);
        FileUtil.deleteFolder(directory);
    }

    public static void ensureDirectoryExists(Path directory) throws IOException {
        if (Files.exists(directory, new LinkOption[0])) {
            if (!Files.isDirectory(directory, new LinkOption[0])) {
                throw new NotDirectoryException(directory.toString());
            }
        } else {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
    }

    public static void deleteFolderIfExists(Path folder) throws IOException {
        try {
            Files.walkFileTree(folder, new FolderDeleter(Files::deleteIfExists));
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }

    public static void deleteFolder(Path folder) throws IOException {
        Files.walkFileTree(folder, new FolderDeleter(Files::delete));
    }

    public static void copySnapshot(Path snapshotDirectory, Path runtimeDirectory) throws Exception {
        Files.walkFileTree(snapshotDirectory, new SnapshotCopier(snapshotDirectory, runtimeDirectory));
    }

    @FunctionalInterface
    private static interface FileDeleter {
        public void delete(Path var1) throws IOException;
    }

    private static final class FolderDeleter
    extends SimpleFileVisitor<Path> {
        private final FileDeleter deleter;

        private FolderDeleter(FileDeleter deleter) {
            this.deleter = Objects.requireNonNull(deleter);
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            this.deleter.delete(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            this.deleter.delete(dir);
            return FileVisitResult.CONTINUE;
        }
    }

    public static final class SnapshotCopier
    extends SimpleFileVisitor<Path> {
        private final Path targetPath;
        private final Path sourcePath;

        SnapshotCopier(Path sourcePath, Path targetPath) {
            this.sourcePath = sourcePath;
            this.targetPath = targetPath;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path newDirectory = this.targetPath.resolve(this.sourcePath.relativize(dir));
            Files.copy(dir, newDirectory, new CopyOption[0]);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Path newFile = this.targetPath.resolve(this.sourcePath.relativize(file));
            Files.copy(file, newFile, new CopyOption[0]);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            return FileVisitResult.CONTINUE;
        }
    }
}

