/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.sched;

import io.camunda.zeebe.util.sched.Actor;
import io.camunda.zeebe.util.sched.ActorExecutor;
import io.camunda.zeebe.util.sched.ActorSchedulingService;
import io.camunda.zeebe.util.sched.ActorTask;
import io.camunda.zeebe.util.sched.ActorThread;
import io.camunda.zeebe.util.sched.ActorThreadGroup;
import io.camunda.zeebe.util.sched.ActorTimerQueue;
import io.camunda.zeebe.util.sched.CpuThreadGroup;
import io.camunda.zeebe.util.sched.IoThreadGroup;
import io.camunda.zeebe.util.sched.SchedulingHints;
import io.camunda.zeebe.util.sched.TaskScheduler;
import io.camunda.zeebe.util.sched.clock.ActorClock;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import java.util.Arrays;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class ActorScheduler
implements AutoCloseable,
ActorSchedulingService {
    private final AtomicReference<SchedulerState> state = new AtomicReference();
    private final ActorExecutor actorTaskExecutor;

    public ActorScheduler(ActorSchedulerBuilder builder) {
        this.state.set(SchedulerState.NEW);
        this.actorTaskExecutor = builder.getActorExecutor();
    }

    @Override
    public ActorFuture<Void> submitActor(Actor actor) {
        this.checkRunningState();
        return this.actorTaskExecutor.submitCpuBound(actor.actor.task);
    }

    @Override
    public ActorFuture<Void> submitActor(Actor actor, int schedulingHints) {
        ActorFuture<Void> startingFuture;
        this.checkRunningState();
        ActorTask task = actor.actor.task;
        if (SchedulingHints.isCpuBound(schedulingHints)) {
            task.setPriority(SchedulingHints.getPriority(schedulingHints));
            startingFuture = this.actorTaskExecutor.submitCpuBound(task);
        } else {
            startingFuture = this.actorTaskExecutor.submitIoBoundTask(task);
        }
        return startingFuture;
    }

    private void checkRunningState() {
        if (this.state.get() != SchedulerState.RUNNING) {
            throw new IllegalStateException("Actor scheduler is not running");
        }
    }

    public void start() {
        if (!this.state.compareAndSet(SchedulerState.NEW, SchedulerState.RUNNING)) {
            throw new IllegalStateException("Cannot start scheduler already started.");
        }
        this.actorTaskExecutor.start();
    }

    public Future<Void> stop() {
        if (this.state.compareAndSet(SchedulerState.RUNNING, SchedulerState.TERMINATING)) {
            return this.actorTaskExecutor.closeAsync().thenRun(() -> this.state.set(SchedulerState.TERMINATED));
        }
        throw new IllegalStateException("Cannot stop scheduler not running");
    }

    @Override
    public void close() throws Exception {
        this.stop().get(10L, TimeUnit.SECONDS);
    }

    public static ActorSchedulerBuilder newActorScheduler() {
        return new ActorSchedulerBuilder();
    }

    private static enum SchedulerState {
        NEW,
        RUNNING,
        TERMINATING,
        TERMINATED;

    }

    public static interface ActorThreadFactory {
        public ActorThread newThread(String var1, int var2, ActorThreadGroup var3, TaskScheduler var4, ActorClock var5, ActorTimerQueue var6);
    }

    public static class DefaultActorThreadFactory
    implements ActorThreadFactory {
        @Override
        public ActorThread newThread(String name, int id, ActorThreadGroup threadGroup, TaskScheduler taskScheduler, ActorClock clock, ActorTimerQueue timerQueue) {
            return new ActorThread(name, id, threadGroup, taskScheduler, clock, timerQueue);
        }
    }

    public static class ActorSchedulerBuilder {
        private final double[] priorityQuotas = new double[]{0.6, 0.3, 0.1};
        private String schedulerName = "";
        private ActorClock actorClock;
        private int cpuBoundThreadsCount = Math.max(1, Runtime.getRuntime().availableProcessors() - 2);
        private ActorThreadGroup cpuBoundActorGroup;
        private int ioBoundThreadsCount = 2;
        private ActorThreadGroup ioBoundActorGroup;
        private ActorThreadFactory actorThreadFactory;
        private ActorExecutor actorExecutor;
        private ActorTimerQueue actorTimerQueue;

        public String getSchedulerName() {
            return this.schedulerName;
        }

        public ActorSchedulerBuilder setSchedulerName(String schedulerName) {
            this.schedulerName = schedulerName;
            return this;
        }

        public ActorClock getActorClock() {
            return this.actorClock;
        }

        public ActorSchedulerBuilder setActorClock(ActorClock actorClock) {
            this.actorClock = actorClock;
            return this;
        }

        public ActorTimerQueue getActorTimerQueue() {
            return this.actorTimerQueue;
        }

        public ActorSchedulerBuilder setActorTimerQueue(ActorTimerQueue actorTimerQueue) {
            this.actorTimerQueue = actorTimerQueue;
            return this;
        }

        public int getCpuBoundActorThreadCount() {
            return this.cpuBoundThreadsCount;
        }

        public ActorSchedulerBuilder setCpuBoundActorThreadCount(int actorThreadCount) {
            this.cpuBoundThreadsCount = actorThreadCount;
            return this;
        }

        public int getIoBoundActorThreadCount() {
            return this.ioBoundThreadsCount;
        }

        public ActorSchedulerBuilder setIoBoundActorThreadCount(int ioBoundActorsThreadCount) {
            this.ioBoundThreadsCount = ioBoundActorsThreadCount;
            return this;
        }

        public double[] getPriorityQuotas() {
            return Arrays.copyOf(this.priorityQuotas, this.priorityQuotas.length);
        }

        public ActorThreadFactory getActorThreadFactory() {
            return this.actorThreadFactory;
        }

        public ActorSchedulerBuilder setActorThreadFactory(ActorThreadFactory actorThreadFactory) {
            this.actorThreadFactory = actorThreadFactory;
            return this;
        }

        public ActorExecutor getActorExecutor() {
            return this.actorExecutor;
        }

        public ActorThreadGroup getCpuBoundActorThreads() {
            return this.cpuBoundActorGroup;
        }

        public ActorThreadGroup getIoBoundActorThreads() {
            return this.ioBoundActorGroup;
        }

        private void initActorThreadFactory() {
            if (this.actorThreadFactory == null) {
                this.actorThreadFactory = new DefaultActorThreadFactory();
            }
        }

        private void initIoBoundActorThreadGroup() {
            if (this.ioBoundActorGroup == null) {
                this.ioBoundActorGroup = new IoThreadGroup(this);
            }
        }

        private void initCpuBoundActorThreadGroup() {
            if (this.cpuBoundActorGroup == null) {
                this.cpuBoundActorGroup = new CpuThreadGroup(this);
            }
        }

        private void initActorExecutor() {
            if (this.actorExecutor == null) {
                this.actorExecutor = new ActorExecutor(this);
            }
        }

        public ActorScheduler build() {
            this.initActorThreadFactory();
            this.initCpuBoundActorThreadGroup();
            this.initIoBoundActorThreadGroup();
            this.initActorExecutor();
            return new ActorScheduler(this);
        }
    }
}

