/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.transport.impl;

import io.atomix.cluster.messaging.MessagingService;
import io.camunda.zeebe.transport.RequestHandler;
import io.camunda.zeebe.transport.RequestType;
import io.camunda.zeebe.transport.ServerResponse;
import io.camunda.zeebe.transport.ServerTransport;
import io.camunda.zeebe.transport.impl.Loggers;
import io.camunda.zeebe.util.sched.Actor;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.Int2ObjectHashMap;
import org.agrona.collections.Long2ObjectHashMap;
import org.agrona.concurrent.UnsafeBuffer;
import org.slf4j.Logger;

public class AtomixServerTransport
extends Actor
implements ServerTransport {
    private static final Logger LOG = Loggers.TRANSPORT_LOGGER;
    private static final String API_TOPIC_FORMAT = "%s-api-%d";
    private static final String ERROR_MSG_MISSING_PARTITON_MAP = "Node already unsubscribed from partition %d, this can only happen when atomix does not cleanly remove its handlers.";
    private final Int2ObjectHashMap<Long2ObjectHashMap<CompletableFuture<byte[]>>> partitionsRequestMap;
    private final AtomicLong requestCount;
    private final DirectBuffer reusableRequestBuffer;
    private final MessagingService messagingService;
    private final String actorName;

    public AtomixServerTransport(int nodeId, MessagingService messagingService) {
        this.messagingService = messagingService;
        this.partitionsRequestMap = new Int2ObjectHashMap();
        this.requestCount = new AtomicLong(0L);
        this.reusableRequestBuffer = new UnsafeBuffer(0L, 0);
        this.actorName = AtomixServerTransport.buildActorName((int)nodeId, (String)"ServerTransport");
    }

    public String getName() {
        return this.actorName;
    }

    @Override
    public void close() {
        this.actor.call(() -> {
            Int2ObjectHashMap.KeyIterator keyIterator = this.partitionsRequestMap.keySet().iterator();
            while (keyIterator.hasNext()) {
                int partitionId = (Integer)keyIterator.next();
                this.removePartition(partitionId);
            }
            this.actor.close();
        }).join();
    }

    @Override
    public ActorFuture<Void> subscribe(int partitionId, RequestType requestType, RequestHandler requestHandler) {
        return this.actor.call(() -> {
            String topicName = AtomixServerTransport.topicName(partitionId, requestType);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Subscribe for topic {}", (Object)topicName);
            }
            this.partitionsRequestMap.computeIfAbsent(partitionId, id -> new Long2ObjectHashMap());
            this.messagingService.registerHandler(topicName, (sender, request) -> this.handleAtomixRequest((byte[])request, partitionId, requestType, requestHandler));
        });
    }

    @Override
    public ActorFuture<Void> unsubscribe(int partitionId) {
        return this.actor.call(() -> this.removePartition(partitionId));
    }

    private void removePartition(int partitionId) {
        Arrays.stream(RequestType.values()).forEach(requestType -> {
            String topicName = AtomixServerTransport.topicName(partitionId, requestType);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Unsubscribe from topic {}", (Object)topicName);
            }
            this.messagingService.unregisterHandler(topicName);
        });
        Long2ObjectHashMap requestMap = (Long2ObjectHashMap)this.partitionsRequestMap.remove(partitionId);
        if (requestMap != null) {
            requestMap.clear();
        }
    }

    private CompletableFuture<byte[]> handleAtomixRequest(byte[] requestBytes, int partitionId, RequestType requestType, RequestHandler requestHandler) {
        CompletableFuture<byte[]> completableFuture = new CompletableFuture<byte[]>();
        this.actor.call(() -> {
            long requestId = this.requestCount.getAndIncrement();
            Long2ObjectHashMap requestMap = (Long2ObjectHashMap)this.partitionsRequestMap.get(partitionId);
            if (requestMap == null) {
                String errorMsg = String.format(ERROR_MSG_MISSING_PARTITON_MAP, partitionId);
                LOG.trace(errorMsg);
                completableFuture.completeExceptionally(new IllegalStateException(errorMsg));
                return;
            }
            try {
                this.reusableRequestBuffer.wrap(requestBytes);
                requestHandler.onRequest(this, partitionId, requestId, this.reusableRequestBuffer, 0, requestBytes.length);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Handled request {} for topic {}", (Object)requestId, (Object)AtomixServerTransport.topicName(partitionId, requestType));
                }
                requestMap.put(requestId, (Object)completableFuture);
            }
            catch (Exception exception) {
                LOG.error("Unexpected exception on handling request for partition {}.", (Object)partitionId, (Object)exception);
                completableFuture.completeExceptionally(exception);
            }
        });
        return completableFuture;
    }

    @Override
    public void sendResponse(ServerResponse response) {
        long requestId = response.getRequestId();
        int partitionId = response.getPartitionId();
        int length = response.getLength();
        byte[] bytes = new byte[length];
        UnsafeBuffer unsafeBuffer = new UnsafeBuffer(bytes);
        response.write((MutableDirectBuffer)unsafeBuffer, 0);
        this.actor.run(() -> {
            Long2ObjectHashMap requestMap = (Long2ObjectHashMap)this.partitionsRequestMap.get(partitionId);
            if (requestMap == null) {
                LOG.warn("Node is no longer leader for partition {}, tried to respond on request with id {}", (Object)partitionId, (Object)requestId);
                return;
            }
            CompletableFuture completableFuture = (CompletableFuture)requestMap.remove(requestId);
            if (completableFuture != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Send response to request {}", (Object)requestId);
                }
                completableFuture.complete(bytes);
            } else if (LOG.isTraceEnabled()) {
                LOG.trace("Wasn't able to send response to request {}", (Object)requestId);
            }
        });
    }

    static String topicName(int partitionId, RequestType requestType) {
        return String.format(API_TOPIC_FORMAT, requestType.getId(), partitionId);
    }
}

