/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft;

import com.google.common.base.Preconditions;
import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.MemberId;
import io.atomix.raft.RaftException;
import io.atomix.raft.RaftRoleChangeListener;
import io.atomix.raft.RaftThreadContextFactory;
import io.atomix.raft.cluster.RaftCluster;
import io.atomix.raft.impl.DefaultRaftServer;
import io.atomix.raft.impl.RaftContext;
import io.atomix.raft.partition.RaftElectionConfig;
import io.atomix.raft.partition.RaftPartitionConfig;
import io.atomix.raft.protocol.RaftServerProtocol;
import io.atomix.raft.storage.RaftStorage;
import io.atomix.raft.zeebe.EntryValidator;
import io.atomix.raft.zeebe.NoopEntryValidator;
import io.camunda.zeebe.util.health.FailureListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public interface RaftServer {
    public static Builder builder() {
        try {
            InetAddress address = InetAddress.getByName("0.0.0.0");
            return RaftServer.builder(MemberId.from(address.getHostName()));
        }
        catch (UnknownHostException e) {
            throw new RaftException.ConfigurationException(e, "Cannot configure local node %s", e.getMessage());
        }
    }

    public static Builder builder(MemberId localMemberId) {
        return new DefaultRaftServer.Builder(localMemberId);
    }

    public String name();

    public RaftCluster cluster();

    public void addRoleChangeListener(RaftRoleChangeListener var1);

    public void removeRoleChangeListener(RaftRoleChangeListener var1);

    public void addFailureListener(FailureListener var1);

    public void removeFailureListener(FailureListener var1);

    default public CompletableFuture<RaftServer> bootstrap() {
        return this.bootstrap(Collections.emptyList());
    }

    public CompletableFuture<RaftServer> bootstrap(Collection<MemberId> var1);

    default public CompletableFuture<RaftServer> bootstrap(MemberId ... members) {
        return this.bootstrap(Arrays.asList(members));
    }

    public CompletableFuture<RaftServer> promote();

    public CompletableFuture<Void> compact();

    public CompletableFuture<Void> shutdown();

    public CompletableFuture<Void> goInactive();

    public RaftContext getContext();

    public long getTerm();

    default public boolean isFollower() {
        return this.getRole() == Role.FOLLOWER;
    }

    public Role getRole();

    default public boolean isLeader() {
        return this.getRole() == Role.LEADER;
    }

    public boolean isRunning();

    public CompletableFuture<Void> stepDown();

    public static enum Role {
        INACTIVE(false),
        PASSIVE(false),
        PROMOTABLE(false),
        FOLLOWER(true),
        CANDIDATE(true),
        LEADER(true);

        private final boolean active;

        private Role(boolean active) {
            this.active = active;
        }

        public boolean active() {
            return this.active;
        }
    }

    public static abstract class Builder
    implements io.atomix.utils.Builder<RaftServer> {
        private static final Duration DEFAULT_ELECTION_TIMEOUT = Duration.ofMillis(750L);
        private static final Duration DEFAULT_HEARTBEAT_INTERVAL = Duration.ofMillis(250L);
        protected String name;
        protected MemberId localMemberId;
        protected ClusterMembershipService membershipService;
        protected RaftServerProtocol protocol;
        protected RaftStorage storage;
        protected RaftThreadContextFactory threadContextFactory;
        protected Supplier<Random> randomFactory;
        protected EntryValidator entryValidator = new NoopEntryValidator();
        protected RaftElectionConfig electionConfig = RaftElectionConfig.ofDefaultElection();
        protected RaftPartitionConfig partitionConfig = new RaftPartitionConfig();
        protected int partitionId;

        protected Builder(MemberId localMemberId) {
            this.localMemberId = (MemberId)Preconditions.checkNotNull((Object)localMemberId, (Object)"localMemberId cannot be null");
        }

        public Builder withName(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
            return this;
        }

        public Builder withMembershipService(ClusterMembershipService membershipService) {
            this.membershipService = (ClusterMembershipService)Preconditions.checkNotNull((Object)membershipService, (Object)"membershipService cannot be null");
            return this;
        }

        public Builder withProtocol(RaftServerProtocol protocol) {
            this.protocol = (RaftServerProtocol)Preconditions.checkNotNull((Object)protocol, (Object)"protocol cannot be null");
            return this;
        }

        public Builder withStorage(RaftStorage storage) {
            this.storage = (RaftStorage)Preconditions.checkNotNull((Object)storage, (Object)"storage cannot be null");
            return this;
        }

        public Builder withThreadContextFactory(RaftThreadContextFactory threadContextFactory) {
            this.threadContextFactory = (RaftThreadContextFactory)Preconditions.checkNotNull((Object)threadContextFactory, (Object)"threadContextFactory cannot be null");
            return this;
        }

        public Builder withEntryValidator(EntryValidator entryValidator) {
            this.entryValidator = entryValidator;
            return this;
        }

        public Builder withElectionConfig(RaftElectionConfig electionConfig) {
            this.electionConfig = electionConfig;
            return this;
        }

        public Builder withPartitionConfig(RaftPartitionConfig partitionConfig) {
            this.partitionConfig = partitionConfig;
            return this;
        }

        public Builder withPartitionId(int partitionId) {
            this.partitionId = partitionId;
            return this;
        }
    }
}

