/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.storage.serializer;

import io.atomix.cluster.MemberId;
import io.atomix.raft.cluster.RaftMember;
import io.atomix.raft.cluster.impl.DefaultRaftMember;
import io.atomix.raft.storage.serializer.ConfigurationDecoder;
import io.atomix.raft.storage.serializer.ConfigurationEncoder;
import io.atomix.raft.storage.serializer.MessageHeaderDecoder;
import io.atomix.raft.storage.serializer.MessageHeaderEncoder;
import io.atomix.raft.storage.serializer.MetaDecoder;
import io.atomix.raft.storage.serializer.MetaEncoder;
import io.atomix.raft.storage.serializer.SerializerUtil;
import io.atomix.raft.storage.system.Configuration;
import java.time.Instant;
import java.util.ArrayList;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class MetaStoreSerializer {
    private final MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
    private final ConfigurationEncoder configurationEncoder = new ConfigurationEncoder();
    private final MetaEncoder metaEncoder = new MetaEncoder();
    private final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    private final ConfigurationDecoder configurationDecoder = new ConfigurationDecoder();
    private final MetaDecoder metaDecoder = new MetaDecoder();

    public int writeConfiguration(Configuration configuration, MutableDirectBuffer buffer, int offset) {
        this.headerEncoder.wrap(buffer, offset).blockLength(this.configurationEncoder.sbeBlockLength()).templateId(this.configurationEncoder.sbeTemplateId()).schemaId(this.configurationEncoder.sbeSchemaId()).version(this.configurationEncoder.sbeSchemaVersion());
        this.configurationEncoder.wrap(buffer, offset + this.headerEncoder.encodedLength());
        this.configurationEncoder.index(configuration.index()).term(configuration.term()).timestamp(configuration.time());
        ConfigurationEncoder.RaftMemberEncoder raftMemberEncoder = this.configurationEncoder.raftMemberCount(configuration.members().size());
        for (RaftMember member : configuration.members()) {
            String memberId = (String)((Object)member.memberId().id());
            raftMemberEncoder.next().type(SerializerUtil.getSBEType(member.getType())).updated(member.getLastUpdated().toEpochMilli()).memberId(memberId);
        }
        return this.headerEncoder.encodedLength() + this.configurationEncoder.encodedLength();
    }

    public Configuration readConfiguration(DirectBuffer buffer, int offset) {
        this.headerDecoder.wrap(buffer, offset);
        if (this.headerDecoder.version() != this.configurationEncoder.sbeSchemaVersion() || this.headerDecoder.templateId() != this.configurationEncoder.sbeTemplateId()) {
            return null;
        }
        this.configurationDecoder.wrap(buffer, offset + this.headerDecoder.encodedLength(), this.headerDecoder.blockLength(), this.headerDecoder.version());
        long index = this.configurationDecoder.index();
        long term = this.configurationDecoder.term();
        long timestamp = this.configurationDecoder.timestamp();
        ConfigurationDecoder.RaftMemberDecoder memberDecoder = this.configurationDecoder.raftMember();
        ArrayList<RaftMember> members = new ArrayList<RaftMember>(memberDecoder.count());
        for (ConfigurationDecoder.RaftMemberDecoder member : memberDecoder) {
            RaftMember.Type type = SerializerUtil.getRaftMemberType(member.type());
            Instant updated = Instant.ofEpochMilli(member.updated());
            String memberId = member.memberId();
            members.add(new DefaultRaftMember(MemberId.from(memberId), type, updated));
        }
        return new Configuration(index, term, timestamp, members);
    }

    public void writeTerm(long term, MutableDirectBuffer buffer, int offset) {
        this.headerEncoder.wrap(buffer, offset).blockLength(this.metaEncoder.sbeBlockLength()).templateId(this.metaEncoder.sbeTemplateId()).schemaId(this.metaEncoder.sbeSchemaId()).version(this.metaEncoder.sbeSchemaVersion());
        this.metaEncoder.wrap(buffer, offset + this.headerEncoder.encodedLength());
        this.metaEncoder.term(term);
    }

    public long readTerm(MutableDirectBuffer buffer, int offset) {
        this.headerDecoder.wrap((DirectBuffer)buffer, offset);
        this.metaDecoder.wrap((DirectBuffer)buffer, offset + this.headerDecoder.encodedLength(), this.headerDecoder.blockLength(), this.headerDecoder.version());
        return this.metaDecoder.term();
    }

    public void writeVotedFor(String memberId, MutableDirectBuffer buffer, int offset) {
        this.headerEncoder.wrap(buffer, offset).blockLength(this.metaEncoder.sbeBlockLength()).templateId(this.metaEncoder.sbeTemplateId()).schemaId(this.metaEncoder.sbeSchemaId()).version(this.metaEncoder.sbeSchemaVersion());
        this.metaEncoder.wrap(buffer, offset + this.headerEncoder.encodedLength());
        this.metaEncoder.votedFor(memberId);
    }

    public String readVotedFor(MutableDirectBuffer buffer, int offset) {
        this.headerDecoder.wrap((DirectBuffer)buffer, offset);
        this.metaDecoder.wrap((DirectBuffer)buffer, offset + this.headerDecoder.encodedLength(), this.headerDecoder.blockLength(), this.headerDecoder.version());
        return this.metaDecoder.votedFor();
    }

    public long readLastWrittenIndex(MutableDirectBuffer buffer, int offset) {
        this.headerDecoder.wrap((DirectBuffer)buffer, offset);
        this.metaDecoder.wrap((DirectBuffer)buffer, offset + this.headerDecoder.encodedLength(), this.headerDecoder.blockLength(), this.headerDecoder.version());
        return this.metaDecoder.lastWrittenIndex();
    }

    public void writeLastWrittenIndex(long index, MutableDirectBuffer buffer, int offset) {
        this.headerEncoder.wrap(buffer, offset).blockLength(this.metaEncoder.sbeBlockLength()).templateId(this.metaEncoder.sbeTemplateId()).schemaId(this.metaEncoder.sbeSchemaId()).version(this.metaEncoder.sbeSchemaVersion());
        this.metaEncoder.wrap(buffer, offset + this.headerEncoder.encodedLength());
        this.metaEncoder.lastWrittenIndex(index);
    }
}

