/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.behavior;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.BpmnProcessingException;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.camunda.zeebe.engine.state.immutable.ElementInstanceState;
import io.camunda.zeebe.engine.state.immutable.VariableState;
import io.camunda.zeebe.engine.state.immutable.ZeebeState;
import io.camunda.zeebe.engine.state.instance.AwaitProcessInstanceResultMetadata;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceResultRecord;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceResultIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.HashSet;
import org.agrona.DirectBuffer;

public final class BpmnProcessResultSenderBehavior {
    private final ProcessInstanceResultRecord resultRecord = new ProcessInstanceResultRecord();
    private final ElementInstanceState elementInstanceState;
    private final VariableState variableState;
    private final TypedResponseWriter responseWriter;

    public BpmnProcessResultSenderBehavior(ZeebeState zeebeState, TypedResponseWriter responseWriter) {
        this.elementInstanceState = zeebeState.getElementInstanceState();
        this.variableState = zeebeState.getVariableState();
        this.responseWriter = responseWriter;
    }

    public void sendResult(BpmnElementContext context) {
        if (context.getBpmnElementType() != BpmnElementType.PROCESS) {
            throw new BpmnProcessingException(context, "Expected to send the result of the process instance but was not called from the process element");
        }
        AwaitProcessInstanceResultMetadata requestMetadata = this.elementInstanceState.getAwaitResultRequestMetadata(context.getProcessInstanceKey());
        if (requestMetadata != null) {
            this.sendResult(context, requestMetadata);
        }
    }

    private void sendResult(BpmnElementContext context, AwaitProcessInstanceResultMetadata requestMetadata) {
        DirectBuffer variablesAsDocument = this.collectVariables(context, requestMetadata);
        this.resultRecord.setProcessInstanceKey(context.getProcessInstanceKey()).setProcessDefinitionKey(context.getProcessDefinitionKey()).setBpmnProcessId(context.getBpmnProcessId()).setVersion(context.getProcessVersion()).setVariables(variablesAsDocument);
        this.responseWriter.writeResponse(context.getProcessInstanceKey(), (Intent)ProcessInstanceResultIntent.COMPLETED, (UnpackedObject)this.resultRecord, ValueType.PROCESS_INSTANCE_RESULT, requestMetadata.getRequestId(), requestMetadata.getRequestStreamId());
        this.responseWriter.flush();
    }

    private DirectBuffer collectVariables(BpmnElementContext context, AwaitProcessInstanceResultMetadata requestMetadata) {
        HashSet<DirectBuffer> variablesToCollect = new HashSet<DirectBuffer>();
        requestMetadata.fetchVariables().forEach(variable -> {
            DirectBuffer variableName = BufferUtil.cloneBuffer((DirectBuffer)variable.getValue());
            variablesToCollect.add(variableName);
        });
        if (variablesToCollect.isEmpty()) {
            return this.variableState.getVariablesAsDocument(context.getProcessInstanceKey());
        }
        return this.variableState.getVariablesAsDocument(context.getProcessInstanceKey(), variablesToCollect);
    }
}

