/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.message;

import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedStreamWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.immutable.ProcessMessageSubscriptionState;
import io.camunda.zeebe.engine.state.message.ProcessMessageSubscription;
import io.camunda.zeebe.protocol.impl.record.value.message.ProcessMessageSubscriptionRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessMessageSubscriptionIntent;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public final class ProcessMessageSubscriptionDeleteProcessor
implements TypedRecordProcessor<ProcessMessageSubscriptionRecord> {
    private static final String NO_SUBSCRIPTION_FOUND_MESSAGE = "Expected to delete process message subscription for element with key '%d' and message name '%s', but no such subscription was found.";
    private final StateWriter stateWriter;
    private final TypedRejectionWriter rejectionWriter;
    private final ProcessMessageSubscriptionState subscriptionState;

    public ProcessMessageSubscriptionDeleteProcessor(ProcessMessageSubscriptionState subscriptionState, Writers writers) {
        this.subscriptionState = subscriptionState;
        this.stateWriter = writers.state();
        this.rejectionWriter = writers.rejection();
    }

    @Override
    public void processRecord(TypedRecord<ProcessMessageSubscriptionRecord> command, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter) {
        ProcessMessageSubscriptionRecord subscriptionRecord = command.getValue();
        ProcessMessageSubscription subscription = this.subscriptionState.getSubscription(command.getValue().getElementInstanceKey(), subscriptionRecord.getMessageNameBuffer());
        if (subscription == null) {
            this.rejectCommand(command);
            return;
        }
        this.stateWriter.appendFollowUpEvent(subscription.getKey(), (Intent)ProcessMessageSubscriptionIntent.DELETED, (RecordValue)subscription.getRecord());
    }

    private void rejectCommand(TypedRecord<ProcessMessageSubscriptionRecord> command) {
        String reason = String.format(NO_SUBSCRIPTION_FOUND_MESSAGE, command.getValue().getElementInstanceKey(), BufferUtil.bufferAsString((DirectBuffer)command.getValue().getMessageNameBuffer()));
        this.rejectionWriter.appendRejection(command, RejectionType.NOT_FOUND, reason);
    }
}

