/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.appliers;

import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEventElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEventSupplier;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowElementContainer;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowNode;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableMultiInstanceBody;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableSequenceFlow;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableStartEvent;
import io.camunda.zeebe.engine.state.TypedEventApplier;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.instance.EventTrigger;
import io.camunda.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableEventScopeInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableVariableState;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import java.util.stream.IntStream;
import org.agrona.DirectBuffer;

final class ProcessInstanceElementActivatingApplier
implements TypedEventApplier<ProcessInstanceIntent, ProcessInstanceRecord> {
    private final MutableElementInstanceState elementInstanceState;
    private final MutableVariableState variableState;
    private final ProcessState processState;
    private final MutableEventScopeInstanceState eventScopeInstanceState;

    public ProcessInstanceElementActivatingApplier(MutableElementInstanceState elementInstanceState, ProcessState processState, MutableVariableState variableState, MutableEventScopeInstanceState eventScopeInstanceState) {
        this.elementInstanceState = elementInstanceState;
        this.processState = processState;
        this.variableState = variableState;
        this.eventScopeInstanceState = eventScopeInstanceState;
    }

    @Override
    public void applyState(long elementInstanceKey, ProcessInstanceRecord value) {
        DirectBuffer variables;
        DirectBuffer temporaryVariables;
        this.createEventScope(elementInstanceKey, value);
        this.cleanupSequenceFlowsTaken(value);
        long processDefinitionKey = value.getProcessDefinitionKey();
        EventTrigger eventTrigger = this.eventScopeInstanceState.peekEventTrigger(processDefinitionKey);
        if (eventTrigger != null && value.getElementIdBuffer().equals(eventTrigger.getElementId())) {
            this.variableState.setTemporaryVariables(elementInstanceKey, eventTrigger.getVariables());
            this.eventScopeInstanceState.deleteTrigger(processDefinitionKey, eventTrigger.getEventKey());
        }
        ElementInstance flowScopeInstance = this.elementInstanceState.getInstance(value.getFlowScopeKey());
        this.elementInstanceState.newInstance(flowScopeInstance, elementInstanceKey, value, ProcessInstanceIntent.ELEMENT_ACTIVATING);
        if (flowScopeInstance == null) {
            ElementInstance parentElementInstance = this.elementInstanceState.getInstance(value.getParentElementInstanceKey());
            if (parentElementInstance == null) {
                return;
            }
            BpmnElementType parentElementType = parentElementInstance.getValue().getBpmnElementType();
            if (parentElementType == BpmnElementType.CALL_ACTIVITY) {
                parentElementInstance.setCalledChildInstanceKey(elementInstanceKey);
                this.elementInstanceState.updateInstance(parentElementInstance);
            }
            return;
        }
        BpmnElementType flowScopeElementType = flowScopeInstance.getValue().getBpmnElementType();
        BpmnElementType currentElementType = value.getBpmnElementType();
        this.decrementActiveSequenceFlow(value, flowScopeInstance, flowScopeElementType, currentElementType);
        if (currentElementType == BpmnElementType.EVENT_SUB_PROCESS && (temporaryVariables = this.variableState.getTemporaryVariables(flowScopeInstance.getKey())) != null) {
            this.variableState.setTemporaryVariables(elementInstanceKey, temporaryVariables);
            this.variableState.removeTemporaryVariables(flowScopeInstance.getKey());
        }
        if (currentElementType == BpmnElementType.START_EVENT && flowScopeElementType == BpmnElementType.EVENT_SUB_PROCESS && (variables = this.variableState.getTemporaryVariables(flowScopeInstance.getKey())) != null) {
            this.variableState.setTemporaryVariables(elementInstanceKey, variables);
            this.variableState.removeTemporaryVariables(flowScopeInstance.getKey());
        }
        if (flowScopeElementType == BpmnElementType.MULTI_INSTANCE_BODY) {
            flowScopeInstance.incrementMultiInstanceLoopCounter();
            this.elementInstanceState.updateInstance(flowScopeInstance);
            int loopCounter = flowScopeInstance.getMultiInstanceLoopCounter();
            this.elementInstanceState.updateInstance(elementInstanceKey, instance -> instance.setMultiInstanceLoopCounter(loopCounter));
        }
    }

    private void cleanupSequenceFlowsTaken(ProcessInstanceRecord value) {
        if (value.getBpmnElementType() != BpmnElementType.PARALLEL_GATEWAY) {
            return;
        }
        ExecutableFlowNode parallelGateway = this.processState.getFlowElement(value.getProcessDefinitionKey(), value.getElementIdBuffer(), ExecutableFlowNode.class);
        this.elementInstanceState.decrementNumberOfTakenSequenceFlows(value.getFlowScopeKey(), parallelGateway.getId());
    }

    private void decrementActiveSequenceFlow(ProcessInstanceRecord value, ElementInstance flowScopeInstance, BpmnElementType flowScopeElementType, BpmnElementType currentElementType) {
        ExecutableCatchEventElement executableCatchEventElement;
        ExecutableSequenceFlow incomingSequenceFlow;
        ExecutableFlowNode previousElement;
        boolean isEventSubProcess;
        boolean bl = isEventSubProcess = currentElementType == BpmnElementType.EVENT_SUB_PROCESS;
        if (currentElementType != BpmnElementType.START_EVENT && currentElementType != BpmnElementType.BOUNDARY_EVENT && currentElementType != BpmnElementType.PARALLEL_GATEWAY && currentElementType != BpmnElementType.INTERMEDIATE_CATCH_EVENT && flowScopeElementType != BpmnElementType.MULTI_INSTANCE_BODY && !isEventSubProcess) {
            flowScopeInstance.decrementActiveSequenceFlows();
            this.elementInstanceState.updateInstance(flowScopeInstance);
        }
        if (currentElementType == BpmnElementType.INTERMEDIATE_CATCH_EVENT && (previousElement = (incomingSequenceFlow = (executableCatchEventElement = this.processState.getFlowElement(value.getProcessDefinitionKey(), value.getElementIdBuffer(), ExecutableCatchEventElement.class)).getIncoming().get(0)).getSource()).getElementType() != BpmnElementType.EVENT_BASED_GATEWAY) {
            flowScopeInstance.decrementActiveSequenceFlows();
            this.elementInstanceState.updateInstance(flowScopeInstance);
        }
        if (currentElementType == BpmnElementType.PARALLEL_GATEWAY) {
            ExecutableFlowNode executableFlowNode = this.processState.getFlowElement(value.getProcessDefinitionKey(), value.getElementIdBuffer(), ExecutableFlowNode.class);
            int size = executableFlowNode.getIncoming().size();
            IntStream.range(0, size).forEach(i -> flowScopeInstance.decrementActiveSequenceFlows());
            this.elementInstanceState.updateInstance(flowScopeInstance);
        }
        if (isEventSubProcess) {
            ExecutableFlowElementContainer executableFlowElementContainer = this.getExecutableFlowElementContainer(value);
            ExecutableStartEvent executableStartEvent = executableFlowElementContainer.getStartEvents().get(0);
            if (executableStartEvent.isInterrupting()) {
                flowScopeInstance.resetActiveSequenceFlows();
            }
            this.elementInstanceState.updateInstance(flowScopeInstance);
        }
    }

    private ExecutableFlowElementContainer getExecutableFlowElementContainer(ProcessInstanceRecord value) {
        return this.processState.getFlowElement(value.getProcessDefinitionKey(), value.getElementIdBuffer(), ExecutableFlowElementContainer.class);
    }

    private void createEventScope(long elementInstanceKey, ProcessInstanceRecord elementRecord) {
        ExecutableFlowNode flowElement;
        Class<ExecutableFlowNode> flowElementClass = ExecutableFlowNode.class;
        if (elementRecord.getBpmnElementType() == BpmnElementType.MULTI_INSTANCE_BODY) {
            flowElementClass = ExecutableMultiInstanceBody.class;
        }
        if ((flowElement = this.processState.getFlowElement(elementRecord.getProcessDefinitionKey(), elementRecord.getElementIdBuffer(), flowElementClass)) instanceof ExecutableCatchEventSupplier) {
            boolean hasEvents;
            ExecutableCatchEventSupplier eventSupplier = (ExecutableCatchEventSupplier)((Object)flowElement);
            boolean bl = hasEvents = !eventSupplier.getEvents().isEmpty();
            if (hasEvents) {
                this.eventScopeInstanceState.createInstance(elementInstanceKey, eventSupplier.getInterruptingElementIds());
            }
        }
    }
}

