/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.deployment;

import io.camunda.zeebe.msgpack.property.ArrayProperty;
import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.value.BaseValue;
import io.camunda.zeebe.msgpack.value.ValueArray;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentResource;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ProcessMetadata;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import java.util.ArrayList;
import java.util.List;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class DeploymentRecord
extends UnifiedRecordValue
implements DeploymentRecordValue {
    public static final String RESOURCES = "resources";
    public static final String PROCESSES = "processesMetadata";
    private final ArrayProperty<DeploymentResource> resourcesProp = new ArrayProperty("resources", (BaseValue)new DeploymentResource());
    private final ArrayProperty<ProcessMetadata> processesMetadataProp = new ArrayProperty("processesMetadata", (BaseValue)new ProcessMetadata());

    public DeploymentRecord() {
        this.declareProperty((BaseProperty)this.resourcesProp).declareProperty(this.processesMetadataProp);
    }

    public ValueArray<ProcessMetadata> processesMetadata() {
        return this.processesMetadataProp;
    }

    public ValueArray<DeploymentResource> resources() {
        return this.resourcesProp;
    }

    public List<io.camunda.zeebe.protocol.record.value.deployment.DeploymentResource> getResources() {
        ArrayList<io.camunda.zeebe.protocol.record.value.deployment.DeploymentResource> resources = new ArrayList<io.camunda.zeebe.protocol.record.value.deployment.DeploymentResource>();
        for (DeploymentResource resource : this.resourcesProp) {
            byte[] bytes = new byte[resource.getLength()];
            UnsafeBuffer copyBuffer = new UnsafeBuffer(bytes);
            resource.write((MutableDirectBuffer)copyBuffer, 0);
            DeploymentResource copiedResource = new DeploymentResource();
            copiedResource.wrap((DirectBuffer)copyBuffer);
            resources.add(copiedResource);
        }
        return resources;
    }

    public List<ProcessMetadataValue> getProcessesMetadata() {
        ArrayList<ProcessMetadataValue> processesMeta = new ArrayList<ProcessMetadataValue>();
        for (ProcessMetadata processRecord : this.processesMetadataProp) {
            byte[] bytes = new byte[processRecord.getLength()];
            UnsafeBuffer copyBuffer = new UnsafeBuffer(bytes);
            processRecord.write((MutableDirectBuffer)copyBuffer, 0);
            ProcessMetadata copiedProcessRecord = new ProcessMetadata();
            copiedProcessRecord.wrap((DirectBuffer)copyBuffer);
            processesMeta.add(copiedProcessRecord);
        }
        return processesMeta;
    }
}

