/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance;

import io.camunda.zeebe.engine.processing.processinstance.ProcessInstanceCommandContext;
import io.camunda.zeebe.engine.processing.processinstance.ProcessInstanceCommandHandlers;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedStreamWriter;
import io.camunda.zeebe.engine.state.immutable.ElementInstanceState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;

public final class ProcessInstanceCommandProcessor
implements TypedRecordProcessor<ProcessInstanceRecord> {
    private final ProcessInstanceCommandHandlers commandHandlers;
    private final ElementInstanceState elementInstanceState;
    private final ProcessInstanceCommandContext context;

    public ProcessInstanceCommandProcessor(MutableElementInstanceState elementInstanceState) {
        this.elementInstanceState = elementInstanceState;
        this.commandHandlers = new ProcessInstanceCommandHandlers();
        this.context = new ProcessInstanceCommandContext(elementInstanceState);
    }

    @Override
    public void processRecord(TypedRecord<ProcessInstanceRecord> record, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter) {
        this.populateCommandContext(record, responseWriter, streamWriter);
        this.commandHandlers.handle(this.context);
    }

    private void populateCommandContext(TypedRecord<ProcessInstanceRecord> record, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter) {
        this.context.setRecord(record);
        this.context.setResponseWriter(responseWriter);
        this.context.setStreamWriter(streamWriter);
        ElementInstance elementInstance = this.elementInstanceState.getInstance(record.getKey());
        this.context.setElementInstance(elementInstance);
    }
}

