/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.log;

import io.camunda.zeebe.dispatcher.Dispatcher;
import io.camunda.zeebe.dispatcher.Dispatchers;
import io.camunda.zeebe.dispatcher.Subscription;
import io.camunda.zeebe.logstreams.impl.Loggers;
import io.camunda.zeebe.logstreams.impl.log.LogStorageAppender;
import io.camunda.zeebe.logstreams.impl.log.LogStreamBatchWriterImpl;
import io.camunda.zeebe.logstreams.impl.log.LogStreamReaderImpl;
import io.camunda.zeebe.logstreams.impl.log.LogStreamWriterImpl;
import io.camunda.zeebe.logstreams.log.LogRecordAwaiter;
import io.camunda.zeebe.logstreams.log.LogStream;
import io.camunda.zeebe.logstreams.log.LogStreamBatchWriter;
import io.camunda.zeebe.logstreams.log.LogStreamReader;
import io.camunda.zeebe.logstreams.log.LogStreamRecordWriter;
import io.camunda.zeebe.logstreams.log.LogStreamWriter;
import io.camunda.zeebe.logstreams.storage.LogStorage;
import io.camunda.zeebe.logstreams.storage.LogStorageReader;
import io.camunda.zeebe.util.CloseableSilently;
import io.camunda.zeebe.util.exception.UnrecoverableException;
import io.camunda.zeebe.util.health.FailureListener;
import io.camunda.zeebe.util.health.HealthStatus;
import io.camunda.zeebe.util.sched.Actor;
import io.camunda.zeebe.util.sched.ActorSchedulingService;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import io.camunda.zeebe.util.sched.future.CompletableActorFuture;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.slf4j.Logger;

public final class LogStreamImpl
extends Actor
implements LogStream,
FailureListener,
LogStorage.CommitListener {
    private static final Logger LOG = Loggers.LOGSTREAMS_LOGGER;
    private static final String APPENDER_SUBSCRIPTION_NAME = "appender";
    private final Set<LogRecordAwaiter> recordAwaiters = new HashSet<LogRecordAwaiter>();
    private final String logName;
    private final int partitionId;
    private final int maxFrameLength;
    private final ActorSchedulingService actorSchedulingService;
    private final List<LogStreamReader> readers;
    private final LogStorage logStorage;
    private final CompletableActorFuture<Void> closeFuture;
    private final int nodeId;
    private final Set<FailureListener> failureListeners = new HashSet<FailureListener>();
    private ActorFuture<LogStorageAppender> appenderFuture;
    private Dispatcher writeBuffer;
    private LogStorageAppender appender;
    private Throwable closeError;
    private final String actorName;
    private volatile HealthStatus healthStatus = HealthStatus.HEALTHY;

    LogStreamImpl(ActorSchedulingService actorSchedulingService, String logName, int partitionId, int nodeId, int maxFrameLength, LogStorage logStorage) {
        this.actorSchedulingService = actorSchedulingService;
        this.logName = logName;
        this.partitionId = partitionId;
        this.nodeId = nodeId;
        this.actorName = LogStreamImpl.buildActorName((int)nodeId, (String)"LogStream", (int)partitionId);
        this.maxFrameLength = maxFrameLength;
        this.logStorage = logStorage;
        this.closeFuture = new CompletableActorFuture();
        this.readers = new ArrayList<LogStreamReader>();
    }

    protected Map<String, String> createContext() {
        Map context = super.createContext();
        context.put("partitionId", Integer.toString(this.partitionId));
        return context;
    }

    public String getName() {
        return this.actorName;
    }

    protected void onActorStarted() {
        this.logStorage.addCommitListener(this);
    }

    protected void onActorClosing() {
        LOG.info("On closing logstream {} close {} readers", (Object)this.logName, (Object)this.readers.size());
        this.readers.forEach(CloseableSilently::close);
        this.logStorage.removeCommitListener(this);
    }

    protected void onActorClosed() {
        if (this.closeError != null) {
            this.closeFuture.completeExceptionally(this.closeError);
        } else {
            this.closeFuture.complete(null);
        }
    }

    @Override
    public void close() {
        this.closeAsync().join();
    }

    public ActorFuture<Void> closeAsync() {
        if (this.actor.isClosed()) {
            return this.closeFuture;
        }
        this.actor.run(() -> this.closeAppender().onComplete((nothing, appenderError) -> {
            this.closeError = appenderError;
            this.actor.close();
        }));
        return this.closeFuture;
    }

    protected void handleFailure(Exception failure) {
        if (failure instanceof UnrecoverableException) {
            this.onUnrecoverableFailure();
        }
        super.handleFailure(failure);
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public String getLogName() {
        return this.logName;
    }

    @Override
    public ActorFuture<LogStreamReader> newLogStreamReader() {
        return this.actor.call(this::createLogStreamReader);
    }

    @Override
    public ActorFuture<LogStreamRecordWriter> newLogStreamRecordWriter() {
        if (this.actor.isClosed()) {
            return CompletableActorFuture.completedExceptionally((Throwable)new RuntimeException("Actor is closed"));
        }
        CompletableActorFuture writerFuture = new CompletableActorFuture();
        this.actor.run(() -> this.createWriter(writerFuture, LogStreamWriterImpl::new));
        return writerFuture;
    }

    @Override
    public ActorFuture<LogStreamBatchWriter> newLogStreamBatchWriter() {
        if (this.actor.isClosed()) {
            return CompletableActorFuture.completedExceptionally((Throwable)new RuntimeException("Actor is closed"));
        }
        CompletableActorFuture writerFuture = new CompletableActorFuture();
        this.actor.run(() -> this.createWriter(writerFuture, LogStreamBatchWriterImpl::new));
        return writerFuture;
    }

    @Override
    public void registerRecordAvailableListener(LogRecordAwaiter recordAwaiter) {
        this.actor.call(() -> this.recordAwaiters.add(recordAwaiter));
    }

    @Override
    public void removeRecordAvailableListener(LogRecordAwaiter recordAwaiter) {
        this.actor.call(() -> this.recordAwaiters.remove(recordAwaiter));
    }

    private void notifyRecordAwaiters() {
        this.recordAwaiters.forEach(LogRecordAwaiter::onRecordAvailable);
    }

    @Override
    public void onCommit() {
        this.actor.call(this::notifyRecordAwaiters);
    }

    private LogStreamReader createLogStreamReader() {
        LogStreamReaderImpl newReader = new LogStreamReaderImpl(this.logStorage.newReader());
        this.readers.add(newReader);
        return newReader;
    }

    private <T extends LogStreamWriter> void createWriter(CompletableActorFuture<T> writerFuture, WriterCreator<T> creator) {
        if (this.appender != null) {
            writerFuture.complete(creator.create(this.partitionId, this.writeBuffer));
        } else if (this.appenderFuture != null) {
            this.appenderFuture.onComplete(this.onOpenAppender(writerFuture, creator));
        } else {
            this.openAppender().onComplete(this.onOpenAppender(writerFuture, creator));
        }
    }

    private <T extends LogStreamWriter> BiConsumer<LogStorageAppender, Throwable> onOpenAppender(CompletableActorFuture<T> writerFuture, WriterCreator<T> creator) {
        return (openedAppender, errorOnOpeningAppender) -> {
            if (errorOnOpeningAppender == null) {
                writerFuture.complete(creator.create(this.partitionId, this.writeBuffer));
            } else {
                writerFuture.completeExceptionally(errorOnOpeningAppender);
            }
        };
    }

    private ActorFuture<Void> closeAppender() {
        CompletableActorFuture closeAppenderFuture = new CompletableActorFuture();
        if (this.appender == null) {
            closeAppenderFuture.complete(null);
            return closeAppenderFuture;
        }
        this.appenderFuture = null;
        LOG.info("Close appender for log stream {}", (Object)this.logName);
        LogStorageAppender toCloseAppender = this.appender;
        Dispatcher toCloseWriteBuffer = this.writeBuffer;
        this.appender = null;
        this.writeBuffer = null;
        toCloseAppender.closeAsync().onComplete((v, t) -> {
            if (t == null) {
                toCloseWriteBuffer.closeAsync().onComplete((BiConsumer)closeAppenderFuture);
            } else {
                closeAppenderFuture.completeExceptionally(t);
            }
        });
        return closeAppenderFuture;
    }

    private ActorFuture<LogStorageAppender> openAppender() {
        long lastPosition;
        CompletableActorFuture appenderOpenFuture;
        if (this.appenderFuture != null) {
            return this.appenderFuture;
        }
        this.appenderFuture = appenderOpenFuture = new CompletableActorFuture();
        try {
            lastPosition = this.getLastPosition();
        }
        catch (UnrecoverableException e) {
            this.onUnrecoverableFailure();
            this.appenderFuture.completeExceptionally((Throwable)e);
            return this.appenderFuture;
        }
        long initialPosition = lastPosition > 0L ? lastPosition + 1L : 1L;
        this.writeBuffer = Dispatchers.create((String)LogStreamImpl.buildActorName((int)this.nodeId, (String)"dispatcher", (int)this.partitionId)).maxFragmentLength(this.maxFrameLength).initialPosition(initialPosition).name(this.logName + "-write-buffer").actorSchedulingService(this.actorSchedulingService).build();
        this.writeBuffer.openSubscriptionAsync(APPENDER_SUBSCRIPTION_NAME).onComplete((subscription, throwable) -> {
            if (throwable == null) {
                this.appender = new LogStorageAppender(LogStreamImpl.buildActorName((int)this.nodeId, (String)"LogAppender", (int)this.partitionId), this.partitionId, this.logStorage, (Subscription)subscription, this.maxFrameLength);
                this.actorSchedulingService.submitActor((Actor)this.appender).onComplete((v, t) -> {
                    if (t != null) {
                        this.onOpenAppenderFailed((Throwable)t);
                    } else {
                        this.appenderFuture.complete((Object)this.appender);
                        this.appender.addFailureListener(this);
                    }
                });
            } else {
                this.onOpenAppenderFailed((Throwable)throwable);
            }
        });
        return appenderOpenFuture;
    }

    private void onOpenAppenderFailed(Throwable error) {
        LOG.error("Unexpected error when opening appender", error);
        this.appenderFuture.completeExceptionally(error);
        this.onFailure();
    }

    private long getLastPosition() {
        try (LogStorageReader storageReader = this.logStorage.newReader();){
            long l;
            try (LogStreamReaderImpl logReader = new LogStreamReaderImpl(storageReader);){
                l = logReader.seekToEnd();
            }
            return l;
        }
    }

    public HealthStatus getHealthStatus() {
        return this.healthStatus;
    }

    public void addFailureListener(FailureListener failureListener) {
        this.actor.run(() -> this.failureListeners.add(failureListener));
    }

    public void removeFailureListener(FailureListener failureListener) {
        this.actor.run(() -> this.failureListeners.remove(failureListener));
    }

    public void onFailure() {
        this.actor.run(() -> {
            this.healthStatus = HealthStatus.UNHEALTHY;
            this.failureListeners.forEach(FailureListener::onFailure);
            this.closeAsync();
        });
    }

    public void onRecovered() {
        this.actor.run(() -> {
            this.healthStatus = HealthStatus.HEALTHY;
            this.failureListeners.forEach(FailureListener::onRecovered);
        });
    }

    public void onUnrecoverableFailure() {
        this.actor.run(() -> {
            this.healthStatus = HealthStatus.DEAD;
            this.failureListeners.forEach(FailureListener::onUnrecoverableFailure);
            this.closeAsync();
        });
    }

    @FunctionalInterface
    private static interface WriterCreator<T extends LogStreamWriter> {
        public T create(int var1, Dispatcher var2);
    }
}

