/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.bootstrap;

import io.camunda.zeebe.broker.PartitionListener;
import io.camunda.zeebe.broker.SpringBrokerBridge;
import io.camunda.zeebe.broker.bootstrap.BrokerStartupContext;
import io.camunda.zeebe.broker.clustering.ClusterServicesImpl;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.monitoring.BrokerHealthCheckService;
import io.camunda.zeebe.protocol.impl.encoding.BrokerInfo;
import io.camunda.zeebe.util.sched.Actor;
import io.camunda.zeebe.util.sched.ActorSchedulingService;
import io.camunda.zeebe.util.sched.ConcurrencyControl;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class BrokerStartupContextImpl
implements BrokerStartupContext {
    private final BrokerInfo brokerInfo;
    private final BrokerCfg configuration;
    private final SpringBrokerBridge springBrokerBridge;
    private final ActorSchedulingService actorSchedulingService;
    private final List<PartitionListener> partitionListeners = new ArrayList<PartitionListener>();
    private ConcurrencyControl concurrencyControl;
    private final BrokerHealthCheckService healthCheckService;
    private ClusterServicesImpl clusterServices;

    public BrokerStartupContextImpl(BrokerInfo brokerInfo, BrokerCfg configuration, SpringBrokerBridge springBrokerBridge, ActorSchedulingService actorSchedulingService, BrokerHealthCheckService healthCheckService) {
        this.brokerInfo = Objects.requireNonNull(brokerInfo);
        this.configuration = Objects.requireNonNull(configuration);
        this.springBrokerBridge = Objects.requireNonNull(springBrokerBridge);
        this.actorSchedulingService = Objects.requireNonNull(actorSchedulingService);
        this.healthCheckService = Objects.requireNonNull(healthCheckService);
    }

    @Override
    public BrokerInfo getBrokerInfo() {
        return this.brokerInfo;
    }

    @Override
    public BrokerCfg getBrokerConfiguration() {
        return this.configuration;
    }

    @Override
    public SpringBrokerBridge getSpringBrokerBridge() {
        return this.springBrokerBridge;
    }

    @Override
    public ConcurrencyControl getConcurrencyControl() {
        return this.concurrencyControl;
    }

    public void setConcurrencyControl(ConcurrencyControl concurrencyControl) {
        this.concurrencyControl = Objects.requireNonNull(concurrencyControl);
    }

    @Override
    public ActorFuture<Void> scheduleActor(Actor actor) {
        return this.actorSchedulingService.submitActor(actor);
    }

    @Override
    public BrokerHealthCheckService getHealthCheckService() {
        return this.healthCheckService;
    }

    @Override
    public void addPartitionListener(PartitionListener listener) {
        this.partitionListeners.add(Objects.requireNonNull(listener));
    }

    @Override
    public void removePartitionListener(PartitionListener listener) {
        this.partitionListeners.remove(Objects.requireNonNull(listener));
    }

    @Override
    public List<PartitionListener> getPartitionListeners() {
        return Collections.unmodifiableList(this.partitionListeners);
    }

    @Override
    public ClusterServicesImpl getClusterServices() {
        return this.clusterServices;
    }

    @Override
    public void setClusterServices(ClusterServicesImpl clusterServices) {
        this.clusterServices = clusterServices;
    }
}

