/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.exporter.debug;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.camunda.zeebe.broker.system.configuration.ExporterCfg;
import io.camunda.zeebe.exporter.api.Exporter;
import io.camunda.zeebe.exporter.api.context.Context;
import io.camunda.zeebe.exporter.api.context.Controller;
import io.camunda.zeebe.protocol.record.Record;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import org.slf4j.Logger;

public class DebugLogExporter
implements Exporter {
    private static final Map<LogLevel, LogFunctionSupplier> LOGGERS = new EnumMap<LogLevel, LogFunctionSupplier>(LogLevel.class);
    private DebugExporterConfiguration configuration;
    private ObjectMapper objectMapper;
    private LogFunction logger;

    public void configure(Context context) {
        this.configuration = (DebugExporterConfiguration)context.getConfiguration().instantiate(DebugExporterConfiguration.class);
        LogLevel logLevel = this.configuration.getLogLevel();
        LogFunctionSupplier supplier = LOGGERS.get((Object)logLevel);
        if (supplier == null) {
            LogLevel[] expectedLogLevels = LOGGERS.keySet().toArray(new LogLevel[0]);
            throw new IllegalStateException(String.format("Expected log level to be one of %s, but instead got %s", new Object[]{Arrays.toString((Object[])expectedLogLevels), logLevel}));
        }
        this.logger = supplier.supply(context.getLogger());
    }

    public void open(Controller controller) {
        this.logger.log("Debug exporter opened", new Object[0]);
        this.objectMapper = new ObjectMapper();
        this.objectMapper.registerModule((Module)new JavaTimeModule());
        this.objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        if (this.configuration.prettyPrint) {
            this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        }
    }

    public void close() {
        this.logger.log("Debug exporter closed", new Object[0]);
    }

    public void export(Record<?> record) {
        try {
            this.logger.log("{}", this.objectMapper.writeValueAsString(record));
        }
        catch (JsonProcessingException e) {
            this.logger.log("Failed to serialize object '{}' to JSON", new Object[]{record, e});
        }
    }

    public static ExporterCfg defaultConfig() {
        ExporterCfg exporterCfg = new ExporterCfg();
        exporterCfg.setClassName(DebugLogExporter.class.getName());
        return exporterCfg;
    }

    public static String defaultExporterId() {
        return DebugLogExporter.class.getSimpleName();
    }

    static {
        LOGGERS.put(LogLevel.TRACE, logger -> (arg_0, arg_1) -> ((Logger)logger).trace(arg_0, arg_1));
        LOGGERS.put(LogLevel.DEBUG, logger -> (arg_0, arg_1) -> ((Logger)logger).debug(arg_0, arg_1));
        LOGGERS.put(LogLevel.INFO, logger -> (arg_0, arg_1) -> ((Logger)logger).info(arg_0, arg_1));
        LOGGERS.put(LogLevel.WARN, logger -> (arg_0, arg_1) -> ((Logger)logger).warn(arg_0, arg_1));
        LOGGERS.put(LogLevel.ERROR, logger -> (arg_0, arg_1) -> ((Logger)logger).error(arg_0, arg_1));
    }

    private static enum LogLevel {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }

    private static interface LogFunction {
        public void log(String var1, Object ... var2);
    }

    private static interface LogFunctionSupplier {
        public LogFunction supply(Logger var1);
    }

    public static class DebugExporterConfiguration {
        private String logLevel = "debug";
        private boolean prettyPrint = false;

        LogLevel getLogLevel() {
            return LogLevel.valueOf(this.logLevel.trim().toUpperCase());
        }

        public void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        public boolean isPrettyPrint() {
            return this.prettyPrint;
        }

        public void setPrettyPrint(boolean prettyPrint) {
            this.prettyPrint = prettyPrint;
        }
    }
}

