/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions;

import io.atomix.raft.RaftServer;
import io.atomix.raft.partition.RaftPartition;
import io.camunda.zeebe.broker.PartitionListener;
import io.camunda.zeebe.broker.exporter.repo.ExporterDescriptor;
import io.camunda.zeebe.broker.exporter.repo.ExporterRepository;
import io.camunda.zeebe.broker.exporter.stream.ExporterDirector;
import io.camunda.zeebe.broker.logstreams.LogDeletionService;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.partitions.PartitionAdminControl;
import io.camunda.zeebe.broker.system.partitions.PartitionAdminControlImpl;
import io.camunda.zeebe.broker.system.partitions.PartitionContext;
import io.camunda.zeebe.broker.system.partitions.PartitionMessagingService;
import io.camunda.zeebe.broker.system.partitions.PartitionStartupContext;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.StateController;
import io.camunda.zeebe.broker.system.partitions.TypedRecordProcessorsFactory;
import io.camunda.zeebe.broker.system.partitions.impl.AsyncSnapshotDirector;
import io.camunda.zeebe.broker.system.partitions.impl.PartitionProcessingState;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.engine.processing.streamprocessor.StreamProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessorFactory;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.CommandResponseWriter;
import io.camunda.zeebe.engine.state.QueryService;
import io.camunda.zeebe.logstreams.log.LogStream;
import io.camunda.zeebe.logstreams.storage.atomix.AtomixLogStorage;
import io.camunda.zeebe.snapshots.ConstructableSnapshotStore;
import io.camunda.zeebe.snapshots.ReceivableSnapshotStore;
import io.camunda.zeebe.util.health.HealthMonitor;
import io.camunda.zeebe.util.sched.ActorControl;
import io.camunda.zeebe.util.sched.ActorSchedulingService;
import io.camunda.zeebe.util.sched.ScheduledTimer;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;

@Deprecated
public class PartitionStartupAndTransitionContextImpl
implements PartitionContext,
PartitionStartupContext,
PartitionTransitionContext {
    private final int nodeId;
    private final List<PartitionListener> partitionListeners;
    private final PartitionMessagingService messagingService;
    private final ActorSchedulingService actorSchedulingService;
    private final BrokerCfg brokerCfg;
    private final RaftPartition raftPartition;
    private final TypedRecordProcessorsFactory typedRecordProcessorsFactory;
    private final Supplier<CommandResponseWriter> commandResponseWriterSupplier;
    private final Supplier<Consumer<TypedRecord<?>>> onProcessedListenerSupplier;
    private final ConstructableSnapshotStore constructableSnapshotStore;
    private final ReceivableSnapshotStore receivableSnapshotStore;
    private final Integer partitionId;
    private final int maxFragmentSize;
    private final ExporterRepository exporterRepository;
    private final PartitionProcessingState partitionProcessingState;
    private final StateController stateController;
    private StreamProcessor streamProcessor;
    private LogStream logStream;
    private LogDeletionService logDeletionService;
    private AsyncSnapshotDirector snapshotDirector;
    private HealthMonitor criticalComponentsHealthMonitor;
    private ZeebeDb zeebeDb;
    private ActorControl actorControl;
    private ScheduledTimer metricsTimer;
    private ExporterDirector exporterDirector;
    private AtomixLogStorage logStorage;
    private QueryService queryService;
    private long currentTerm;
    private RaftServer.Role currentRole;

    public PartitionStartupAndTransitionContextImpl(int nodeId, RaftPartition raftPartition, List<PartitionListener> partitionListeners, PartitionMessagingService messagingService, ActorSchedulingService actorSchedulingService, BrokerCfg brokerCfg, Supplier<CommandResponseWriter> commandResponseWriterSupplier, Supplier<Consumer<TypedRecord<?>>> onProcessedListenerSupplier, ConstructableSnapshotStore constructableSnapshotStore, ReceivableSnapshotStore receivableSnapshotStore, StateController stateController, TypedRecordProcessorsFactory typedRecordProcessorsFactory, ExporterRepository exporterRepository, PartitionProcessingState partitionProcessingState) {
        this.nodeId = nodeId;
        this.raftPartition = raftPartition;
        this.messagingService = messagingService;
        this.brokerCfg = brokerCfg;
        this.stateController = stateController;
        this.typedRecordProcessorsFactory = typedRecordProcessorsFactory;
        this.onProcessedListenerSupplier = onProcessedListenerSupplier;
        this.commandResponseWriterSupplier = commandResponseWriterSupplier;
        this.constructableSnapshotStore = constructableSnapshotStore;
        this.receivableSnapshotStore = receivableSnapshotStore;
        this.partitionListeners = Collections.unmodifiableList(partitionListeners);
        this.partitionId = (Integer)raftPartition.id().id();
        this.actorSchedulingService = actorSchedulingService;
        this.maxFragmentSize = (int)brokerCfg.getNetwork().getMaxMessageSizeInBytes();
        this.exporterRepository = exporterRepository;
        this.partitionProcessingState = partitionProcessingState;
    }

    @Override
    public PartitionContext getPartitionContext() {
        return this;
    }

    public PartitionAdminControl getPartitionAdminControl() {
        return new PartitionAdminControlImpl(() -> this.getPartitionContext().getStreamProcessor(), () -> this.getPartitionContext().getExporterDirector(), () -> this.snapshotDirector, () -> this.partitionProcessingState);
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public RaftPartition getRaftPartition() {
        return this.raftPartition;
    }

    @Override
    public List<ActorFuture<Void>> notifyListenersOfBecomingLeader(long newTerm) {
        return this.partitionListeners.stream().map(l -> l.onBecomingLeader(this.getPartitionId(), newTerm, this.getLogStream(), this.getQueryService())).collect(Collectors.toList());
    }

    @Override
    public List<ActorFuture<Void>> notifyListenersOfBecomingFollower(long newTerm) {
        return this.partitionListeners.stream().map(l -> l.onBecomingFollower(this.getPartitionId(), newTerm)).collect(Collectors.toList());
    }

    @Override
    public void notifyListenersOfBecomingInactive() {
        this.partitionListeners.forEach(l -> l.onBecomingInactive(this.getPartitionId(), this.getCurrentTerm()));
    }

    @Override
    public RaftServer.Role getCurrentRole() {
        return this.currentRole;
    }

    @Override
    public long getCurrentTerm() {
        return this.currentTerm;
    }

    @Override
    public HealthMonitor getComponentHealthMonitor() {
        return this.criticalComponentsHealthMonitor;
    }

    @Override
    public void setComponentHealthMonitor(HealthMonitor criticalComponentsHealthMonitor) {
        this.criticalComponentsHealthMonitor = criticalComponentsHealthMonitor;
    }

    @Override
    public StateController getStateController() {
        return this.stateController;
    }

    @Override
    public LogDeletionService getLogDeletionService() {
        return this.logDeletionService;
    }

    @Override
    public void setLogDeletionService(LogDeletionService logDeletionService) {
        this.logDeletionService = logDeletionService;
    }

    @Override
    public LogStream getLogStream() {
        return this.logStream;
    }

    @Override
    public void setLogStream(LogStream logStream) {
        this.logStream = logStream;
    }

    @Override
    public ZeebeDb getZeebeDb() {
        return this.zeebeDb;
    }

    @Override
    public void setZeebeDb(ZeebeDb zeebeDb) {
        this.zeebeDb = zeebeDb;
    }

    @Override
    public StreamProcessor getStreamProcessor() {
        return this.streamProcessor;
    }

    @Override
    public void setStreamProcessor(StreamProcessor streamProcessor) {
        this.streamProcessor = streamProcessor;
    }

    @Override
    public AsyncSnapshotDirector getSnapshotDirector() {
        return this.snapshotDirector;
    }

    @Override
    public void setSnapshotDirector(AsyncSnapshotDirector snapshotDirector) {
        this.snapshotDirector = snapshotDirector;
    }

    @Override
    public ScheduledTimer getMetricsTimer() {
        return this.metricsTimer;
    }

    @Override
    public void setMetricsTimer(ScheduledTimer metricsTimer) {
        this.metricsTimer = metricsTimer;
    }

    @Override
    public ExporterDirector getExporterDirector() {
        return this.exporterDirector;
    }

    @Override
    public void setExporterDirector(ExporterDirector exporterDirector) {
        this.exporterDirector = exporterDirector;
    }

    @Override
    public QueryService getQueryService() {
        return this.queryService;
    }

    @Override
    public void setQueryService(QueryService queryService) {
        this.queryService = queryService;
    }

    @Override
    public PartitionStartupAndTransitionContextImpl createTransitionContext() {
        return this;
    }

    @Override
    public boolean shouldProcess() {
        return this.partitionProcessingState.shouldProcess();
    }

    @Override
    public void setDiskSpaceAvailable(boolean diskSpaceAvailable) {
        this.partitionProcessingState.setDiskSpaceAvailable(diskSpaceAvailable);
    }

    @Override
    public void setCurrentTerm(long currentTerm) {
        this.currentTerm = currentTerm;
    }

    @Override
    public void setCurrentRole(RaftServer.Role currentRole) {
        this.currentRole = currentRole;
    }

    @Override
    public TypedRecordProcessorFactory getStreamProcessorFactory() {
        return this.typedRecordProcessorsFactory::createTypedStreamProcessor;
    }

    @Override
    public AtomixLogStorage getLogStorage() {
        return this.logStorage;
    }

    @Override
    public void setLogStorage(AtomixLogStorage logStorage) {
        this.logStorage = logStorage;
    }

    @Override
    public BrokerCfg getBrokerCfg() {
        return this.brokerCfg;
    }

    @Override
    public int getNodeId() {
        return this.nodeId;
    }

    @Override
    public ActorSchedulingService getActorSchedulingService() {
        return this.actorSchedulingService;
    }

    @Override
    public PartitionMessagingService getMessagingService() {
        return this.messagingService;
    }

    @Override
    public ConstructableSnapshotStore getConstructableSnapshotStore() {
        return this.constructableSnapshotStore;
    }

    @Override
    public ReceivableSnapshotStore getReceivableSnapshotStore() {
        return this.receivableSnapshotStore;
    }

    @Override
    public CommandResponseWriter getCommandResponseWriter() {
        return this.commandResponseWriterSupplier.get();
    }

    @Override
    public Consumer<TypedRecord<?>> getOnProcessedListener() {
        return this.onProcessedListenerSupplier.get();
    }

    @Override
    public ExporterRepository getExporterRepository() {
        return this.exporterRepository;
    }

    @Override
    public List<PartitionListener> getPartitionListeners() {
        return this.partitionListeners;
    }

    @Override
    public ActorControl getActorControl() {
        return this.actorControl;
    }

    @Override
    public void setActorControl(ActorControl actorControl) {
        this.actorControl = actorControl;
    }

    @Override
    public int getMaxFragmentSize() {
        return this.maxFragmentSize;
    }

    @Override
    public boolean shouldExport() {
        return !this.partitionProcessingState.isExportingPaused();
    }

    @Override
    public Collection<ExporterDescriptor> getExportedDescriptors() {
        return this.getExporterRepository().getExporters().values();
    }
}

