/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.journal.file;

import io.camunda.zeebe.journal.JournalException;
import io.camunda.zeebe.journal.JournalRecord;
import io.camunda.zeebe.journal.file.ChecksumGenerator;
import io.camunda.zeebe.journal.file.FrameUtil;
import io.camunda.zeebe.journal.file.JournalIndex;
import io.camunda.zeebe.journal.file.JournalSegment;
import io.camunda.zeebe.journal.file.record.CorruptedLogException;
import io.camunda.zeebe.journal.file.record.JournalRecordReaderUtil;
import io.camunda.zeebe.journal.file.record.JournalRecordSerializer;
import io.camunda.zeebe.journal.file.record.PersistedJournalRecord;
import io.camunda.zeebe.journal.file.record.RecordData;
import io.camunda.zeebe.journal.file.record.RecordMetadata;
import io.camunda.zeebe.journal.file.record.SBESerializer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

class MappedJournalSegmentWriter {
    private final MappedByteBuffer buffer;
    private final JournalSegment segment;
    private final JournalIndex index;
    private final long firstIndex;
    private JournalRecord lastEntry;
    private boolean isOpen = true;
    private final JournalRecordReaderUtil recordUtil;
    private final ChecksumGenerator checksumGenerator = new ChecksumGenerator();
    private final JournalRecordSerializer serializer = new SBESerializer();
    private final MutableDirectBuffer writeBuffer = new UnsafeBuffer();
    private final int descriptorLength;

    MappedJournalSegmentWriter(MappedByteBuffer buffer, JournalSegment segment, JournalIndex index, long lastWrittenIndex) {
        this.segment = segment;
        this.descriptorLength = segment.descriptor().length();
        this.recordUtil = new JournalRecordReaderUtil(this.serializer);
        this.index = index;
        this.firstIndex = segment.index();
        this.buffer = buffer;
        this.writeBuffer.wrap((ByteBuffer)buffer);
        this.reset(0L, lastWrittenIndex);
    }

    public long getLastIndex() {
        return this.lastEntry != null ? this.lastEntry.index() : this.segment.index() - 1L;
    }

    public JournalRecord getLastEntry() {
        return this.lastEntry;
    }

    public long getNextIndex() {
        if (this.lastEntry != null) {
            return this.lastEntry.index() + 1L;
        }
        return this.firstIndex;
    }

    public JournalRecord append(long asqn, DirectBuffer data) {
        int recordLength;
        long recordIndex = this.getNextIndex();
        int startPosition = this.buffer.position();
        int frameLength = FrameUtil.getLength();
        int metadataLength = this.serializer.getMetadataLength();
        RecordData indexedRecord = new RecordData(recordIndex, asqn, data);
        try {
            recordLength = this.writeRecord(startPosition + frameLength + metadataLength, indexedRecord);
        }
        catch (BufferOverflowException boe) {
            this.buffer.position(startPosition);
            throw boe;
        }
        long checksum = this.checksumGenerator.compute(this.buffer, startPosition + frameLength + metadataLength, recordLength);
        this.writeMetadata(startPosition, frameLength, recordLength, checksum);
        this.updateLastWrittenEntry(startPosition, frameLength, metadataLength, recordLength);
        FrameUtil.writeVersion(this.buffer, startPosition);
        this.buffer.position(startPosition + frameLength + metadataLength + recordLength);
        return this.lastEntry;
    }

    public void append(JournalRecord record) {
        int recordLength;
        long nextIndex = this.getNextIndex();
        if (record.index() != nextIndex) {
            throw new JournalException.InvalidIndex(String.format("The record index is not sequential. Expected the next index to be %d, but the record to append has index %d", nextIndex, record.index()));
        }
        int startPosition = this.buffer.position();
        int frameLength = FrameUtil.getLength();
        int metadataLength = this.serializer.getMetadataLength();
        RecordData indexedRecord = new RecordData(record.index(), record.asqn(), record.data());
        try {
            recordLength = this.writeRecord(startPosition + frameLength + metadataLength, indexedRecord);
        }
        catch (BufferOverflowException boe) {
            this.buffer.position(startPosition);
            throw boe;
        }
        long checksum = this.checksumGenerator.compute(this.buffer, startPosition + frameLength + metadataLength, recordLength);
        if (record.checksum() != checksum) {
            this.buffer.position(startPosition);
            throw new JournalException.InvalidChecksum(String.format("Failed to append record %s. Checksum does not match", record));
        }
        this.writeMetadata(startPosition, frameLength, recordLength, checksum);
        this.updateLastWrittenEntry(startPosition, frameLength, metadataLength, recordLength);
        FrameUtil.writeVersion(this.buffer, startPosition);
        this.buffer.position(startPosition + frameLength + metadataLength + recordLength);
    }

    private void updateLastWrittenEntry(int startPosition, int frameLength, int metadataLength, int recordLength) {
        RecordMetadata metadata = this.serializer.readMetadata((DirectBuffer)this.writeBuffer, startPosition + frameLength);
        RecordData data = this.serializer.readData((DirectBuffer)this.writeBuffer, startPosition + frameLength + metadataLength, recordLength);
        this.lastEntry = new PersistedJournalRecord(metadata, data);
        this.index.index(this.lastEntry, startPosition);
    }

    private RecordMetadata writeMetadata(int startPosition, int frameLength, int recordLength, long checksum) {
        RecordMetadata recordMetadata = new RecordMetadata(checksum, recordLength);
        this.serializer.writeMetadata(recordMetadata, this.writeBuffer, startPosition + frameLength);
        return recordMetadata;
    }

    private int writeRecord(int offset, RecordData indexedRecord) {
        int recordLength = this.serializer.writeData(indexedRecord, this.writeBuffer, offset);
        int nextEntryOffset = offset + recordLength;
        this.invalidateNextEntry(nextEntryOffset);
        return recordLength;
    }

    private void invalidateNextEntry(int position) {
        if (position >= this.buffer.capacity()) {
            return;
        }
        FrameUtil.markAsIgnored(this.buffer, position);
    }

    private void reset(long index) {
        this.reset(index, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset(long index, long lastWrittenIndex) {
        long nextIndex;
        this.buffer.position(this.descriptorLength);
        this.buffer.mark();
        int position = this.buffer.position();
        try {
            for (nextIndex = this.firstIndex; (index == 0L || nextIndex <= index) && FrameUtil.hasValidVersion(this.buffer); ++nextIndex) {
                FrameUtil.readVersion(this.buffer);
                this.lastEntry = this.recordUtil.read(this.buffer, nextIndex);
                this.index.index(this.lastEntry, position);
                this.buffer.mark();
                position = this.buffer.position();
            }
        }
        catch (BufferUnderflowException bufferUnderflowException) {
        }
        catch (CorruptedLogException e) {
            this.handleChecksumMismatch(e, nextIndex, lastWrittenIndex, position);
        }
        finally {
            this.buffer.reset();
        }
    }

    private void handleChecksumMismatch(CorruptedLogException e, long nextIndex, long lastWrittenIndex, int position) {
        if (nextIndex > lastWrittenIndex) {
            FrameUtil.markAsIgnored(this.buffer, position);
            this.buffer.position(position);
            this.buffer.mark();
            return;
        }
        throw e;
    }

    public void truncate(long index) {
        if (index >= this.getLastIndex()) {
            return;
        }
        this.lastEntry = null;
        this.index.deleteAfter(index);
        if (index < this.segment.index()) {
            this.buffer.position(this.descriptorLength);
            this.invalidateNextEntry(this.descriptorLength);
        } else {
            this.reset(index);
            this.invalidateNextEntry(this.buffer.position());
        }
    }

    public void flush() {
        this.buffer.force();
    }

    public void close() {
        if (this.isOpen) {
            this.isOpen = false;
            this.flush();
        }
    }

    public boolean isEmpty() {
        return this.lastEntry == null;
    }
}

