/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.health;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.Status;
import org.springframework.scheduling.annotation.Scheduled;

public class DelayedHealthIndicator
implements HealthIndicator {
    private final HealthIndicator originalHealthIndicator;
    private final Duration maxDowntime;
    private final Supplier<Long> clock;
    private Health lastHealthStatus;
    private Long lastTimeUp;
    private final Map<String, Object> staticDetails = new HashMap<String, Object>();

    protected DelayedHealthIndicator(HealthIndicator originalHealthIndicator, Duration maxDowntime, Supplier<Long> clock) {
        if (Objects.requireNonNull(maxDowntime).toMillis() < 0L) {
            throw new IllegalArgumentException("maxDonwtime must be >= 0");
        }
        this.originalHealthIndicator = Objects.requireNonNull(originalHealthIndicator);
        this.maxDowntime = maxDowntime;
        this.clock = Objects.requireNonNull(clock);
        this.staticDetails.put("derivedFrom", originalHealthIndicator.getClass().getSimpleName());
        this.staticDetails.put("maxDowntime", maxDowntime);
    }

    public DelayedHealthIndicator(HealthIndicator originalHealthIndicator, Duration maxDowntime) {
        this(originalHealthIndicator, maxDowntime, () -> System.currentTimeMillis());
    }

    @Scheduled(fixedDelay=5000L)
    public void checkHealth() {
        this.lastHealthStatus = this.originalHealthIndicator.health();
        if (this.lastHealthStatus.getStatus().equals((Object)Status.UP)) {
            this.lastTimeUp = this.clock.get();
        }
    }

    public Health health() {
        long now = this.clock.get();
        Health.Builder responseBuilder = this.lastHealthStatus == null ? Health.unknown() : (this.lastTimeUp == null ? Health.status((Status)this.lastHealthStatus.getStatus()) : (this.lastTimeUp + this.maxDowntime.toMillis() > now ? Health.up() : Health.status((Status)this.lastHealthStatus.getStatus())));
        return responseBuilder.withDetails(this.createDetails(now)).build();
    }

    private Map<String, Object> createDetails(long referenceTime) {
        HashMap<String, Object> result = new HashMap<String, Object>(this.staticDetails);
        if (this.lastHealthStatus != null) {
            result.put("lastSeenDelegateHealthStatus", this.lastHealthStatus);
        }
        result.put("wasEverUp", this.lastTimeUp != null);
        if (this.lastTimeUp != null && this.lastHealthStatus != null && this.lastHealthStatus.getStatus() != Status.UP) {
            result.put("downTime", Duration.ofMillis(referenceTime - this.lastTimeUp));
        }
        return result;
    }
}

