/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.behavior;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.BpmnProcessingException;
import io.camunda.zeebe.engine.processing.variable.VariableBehavior;
import io.camunda.zeebe.engine.state.deployment.DeployedProcess;
import io.camunda.zeebe.engine.state.immutable.ElementInstanceState;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.engine.state.immutable.VariableState;
import io.camunda.zeebe.engine.state.immutable.ZeebeState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.agrona.DirectBuffer;

public final class BpmnStateBehavior {
    private final ElementInstanceState elementInstanceState;
    private final VariableState variablesState;
    private final JobState jobState;
    private final ProcessState processState;
    private final VariableBehavior variableBehavior;

    public BpmnStateBehavior(ZeebeState zeebeState, VariableBehavior variableBehavior) {
        this.variableBehavior = variableBehavior;
        this.processState = zeebeState.getProcessState();
        this.elementInstanceState = zeebeState.getElementInstanceState();
        this.variablesState = zeebeState.getVariableState();
        this.jobState = zeebeState.getJobState();
    }

    public ElementInstance getElementInstance(BpmnElementContext context) {
        return this.getElementInstance(context.getElementInstanceKey());
    }

    public ElementInstance getElementInstance(long elementInstanceKey) {
        return this.elementInstanceState.getInstance(elementInstanceKey);
    }

    public JobState getJobState() {
        return this.jobState;
    }

    public boolean canBeTerminated(BpmnElementContext context) {
        ElementInstance flowScopeInstance = this.getFlowScopeInstance(context);
        if (flowScopeInstance == null) {
            return false;
        }
        long activePaths = flowScopeInstance.getNumberOfActiveElementInstances();
        if (activePaths < 0L) {
            throw new BpmnProcessingException(context, String.format("Expected number of active paths to be positive but got %d for instance %s", new Object[]{activePaths, flowScopeInstance}));
        }
        return activePaths == 0L;
    }

    public boolean canBeCompleted(BpmnElementContext context) {
        ElementInstance flowScopeInstance = this.getFlowScopeInstance(context);
        if (flowScopeInstance == null) {
            return false;
        }
        long activePaths = (long)flowScopeInstance.getNumberOfActiveElementInstances() + flowScopeInstance.getActiveSequenceFlows();
        if (activePaths < 0L) {
            throw new BpmnProcessingException(context, String.format("Expected number of active paths to be positive but got %d for instance %s", new Object[]{activePaths, flowScopeInstance}));
        }
        return activePaths == 0L;
    }

    public ElementInstance getFlowScopeInstance(BpmnElementContext context) {
        return this.elementInstanceState.getInstance(context.getFlowScopeKey());
    }

    public List<BpmnElementContext> getChildInstances(BpmnElementContext context) {
        return this.elementInstanceState.getChildren(context.getElementInstanceKey()).stream().map(childInstance -> context.copy(childInstance.getKey(), childInstance.getValue(), childInstance.getState())).collect(Collectors.toList());
    }

    public BpmnElementContext getFlowScopeContext(BpmnElementContext context) {
        ElementInstance flowScope = this.getFlowScopeInstance(context);
        return context.copy(flowScope.getKey(), flowScope.getValue(), flowScope.getState());
    }

    public BpmnElementContext getParentElementInstanceContext(BpmnElementContext context) {
        ElementInstance parentElementInstance = this.elementInstanceState.getInstance(context.getParentElementInstanceKey());
        return context.copy(parentElementInstance.getKey(), parentElementInstance.getValue(), parentElementInstance.getState());
    }

    public Optional<DeployedProcess> getProcess(long processDefinitionKey) {
        return Optional.ofNullable(this.processState.getProcessByKey(processDefinitionKey));
    }

    public Optional<DeployedProcess> getLatestProcessVersion(DirectBuffer processId) {
        DeployedProcess process = this.processState.getLatestProcessVersionByProcessId(processId);
        return Optional.ofNullable(process);
    }

    public Optional<ElementInstance> getCalledChildInstance(BpmnElementContext context) {
        ElementInstance elementInstance = this.getElementInstance(context);
        long calledChildInstanceKey = elementInstance.getCalledChildInstanceKey();
        return Optional.ofNullable(this.elementInstanceState.getInstance(calledChildInstanceKey));
    }

    public DirectBuffer getLocalVariable(BpmnElementContext context, DirectBuffer variableName) {
        return this.variablesState.getVariableLocal(context.getElementInstanceKey(), variableName);
    }

    public void setLocalVariable(BpmnElementContext context, DirectBuffer variableName, DirectBuffer variableValue) {
        this.setLocalVariable(context, variableName, variableValue, 0, variableValue.capacity());
    }

    public void setLocalVariable(BpmnElementContext context, DirectBuffer variableName, DirectBuffer variableValue, int valueOffset, int valueLength) {
        this.variableBehavior.setLocalVariable(context.getElementInstanceKey(), context.getProcessDefinitionKey(), context.getProcessInstanceKey(), variableName, variableValue, valueOffset, valueLength);
    }

    public void propagateVariable(BpmnElementContext context, DirectBuffer variableName) {
        long sourceScope = context.getElementInstanceKey();
        long targetScope = context.getFlowScopeKey();
        DirectBuffer variablesAsDocument = this.variablesState.getVariablesAsDocument(sourceScope, List.of(variableName));
        this.variableBehavior.mergeDocument(targetScope, context.getProcessDefinitionKey(), context.getProcessInstanceKey(), variablesAsDocument);
    }

    public void copyVariablesToProcessInstance(long sourceScopeKey, long targetProcessInstanceKey, DeployedProcess targetProcess) {
        DirectBuffer variables = this.variablesState.getVariablesAsDocument(sourceScopeKey);
        this.variableBehavior.mergeDocument(targetProcessInstanceKey, targetProcess.getKey(), targetProcessInstanceKey, variables);
    }

    public boolean isInterrupted(BpmnElementContext flowScopeContext) {
        ElementInstance flowScopeInstance = this.elementInstanceState.getInstance(flowScopeContext.getElementInstanceKey());
        return flowScopeInstance.getNumberOfActiveElementInstances() == 0 && flowScopeInstance.isInterrupted() && flowScopeInstance.isActive();
    }
}

