/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.behavior;

import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import java.util.function.Consumer;

public final class TypedResponseWriterProxy
implements TypedResponseWriter {
    private TypedResponseWriter writer;
    private Consumer<TypedResponseWriter> flushCallback;

    public void wrap(TypedResponseWriter writer, Consumer<TypedResponseWriter> flushCallback) {
        this.writer = writer;
        this.flushCallback = flushCallback;
    }

    @Override
    public void writeRejectionOnCommand(TypedRecord<?> command, RejectionType type, String reason) {
        this.writer.writeRejectionOnCommand(command, type, reason);
    }

    @Override
    public void writeEvent(TypedRecord<?> event) {
        this.writer.writeEvent(event);
    }

    @Override
    public void writeEventOnCommand(long eventKey, Intent eventState, UnpackedObject eventValue, TypedRecord<?> command) {
        this.writer.writeEventOnCommand(eventKey, eventState, eventValue, command);
    }

    @Override
    public void writeResponse(long eventKey, Intent eventState, UnpackedObject eventValue, ValueType valueType, long requestId, int requestStreamId) {
        this.writer.writeResponse(eventKey, eventState, eventValue, valueType, requestId, requestStreamId);
    }

    @Override
    public boolean flush() {
        this.flushCallback.accept(this.writer);
        return true;
    }

    @Override
    public void reset() {
        this.writer.reset();
    }
}

