/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.distribute;

import io.camunda.zeebe.engine.processing.deployment.DeploymentResponder;
import io.camunda.zeebe.engine.processing.deployment.MessageStartEventSubscriptionManager;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.sideeffect.SideEffectProducer;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedStreamWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.KeyGenerator;
import io.camunda.zeebe.engine.state.immutable.MessageStartEventSubscriptionState;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import java.util.function.Consumer;

public final class DeploymentDistributeProcessor
implements TypedRecordProcessor<DeploymentRecord> {
    private final MessageStartEventSubscriptionManager messageStartEventSubscriptionManager;
    private final DeploymentResponder deploymentResponder;
    private final int partitionId;
    private final StateWriter stateWriter;

    public DeploymentDistributeProcessor(ProcessState processState, MessageStartEventSubscriptionState messageStartEventSubscriptionState, DeploymentResponder deploymentResponder, int partitionId, Writers writers, KeyGenerator keyGenerator) {
        this.messageStartEventSubscriptionManager = new MessageStartEventSubscriptionManager(processState, messageStartEventSubscriptionState, keyGenerator);
        this.deploymentResponder = deploymentResponder;
        this.partitionId = partitionId;
        this.stateWriter = writers.state();
    }

    @Override
    public void processRecord(long position, TypedRecord<DeploymentRecord> event, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter, Consumer<SideEffectProducer> sideEffect) {
        DeploymentRecord deploymentEvent = event.getValue();
        long deploymentKey = event.getKey();
        this.stateWriter.appendFollowUpEvent(deploymentKey, (Intent)DeploymentIntent.DISTRIBUTED, (RecordValue)deploymentEvent);
        this.deploymentResponder.sendDeploymentResponse(deploymentKey, this.partitionId);
        this.messageStartEventSubscriptionManager.tryReOpenMessageStartEventSubscription(deploymentEvent, this.stateWriter);
    }
}

