/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.message;

import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedCommandWriter;
import io.camunda.zeebe.engine.state.immutable.MessageState;
import io.camunda.zeebe.engine.state.message.StoredMessage;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.MessageIntent;
import io.camunda.zeebe.util.sched.clock.ActorClock;

public final class MessageTimeToLiveChecker
implements Runnable {
    private final TypedCommandWriter writer;
    private final MessageState messageState;
    private final MessageRecord deleteMessageCommand = new MessageRecord();

    public MessageTimeToLiveChecker(TypedCommandWriter writer, MessageState messageState) {
        this.writer = writer;
        this.messageState = messageState;
    }

    @Override
    public void run() {
        this.messageState.visitMessagesWithDeadlineBefore(ActorClock.currentTimeMillis(), this::writeDeleteMessageCommand);
    }

    private boolean writeDeleteMessageCommand(StoredMessage storedMessage) {
        MessageRecord message = storedMessage.getMessage();
        this.deleteMessageCommand.reset();
        this.deleteMessageCommand.setName(message.getName()).setCorrelationKey(message.getCorrelationKey()).setTimeToLive(message.getTimeToLive()).setVariables(message.getVariablesBuffer());
        if (message.hasMessageId()) {
            this.deleteMessageCommand.setMessageId(message.getMessageIdBuffer());
        }
        this.writer.reset();
        this.writer.appendFollowUpCommand(storedMessage.getMessageKey(), (Intent)MessageIntent.EXPIRE, (RecordValue)this.deleteMessageCommand);
        long position = this.writer.flush();
        return position > 0L;
    }
}

