/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.message.command;

import io.camunda.zeebe.engine.processing.message.command.CloseProcessMessageSubscriptionDecoder;
import io.camunda.zeebe.engine.processing.message.command.CloseProcessMessageSubscriptionEncoder;
import io.camunda.zeebe.protocol.impl.encoding.SbeBufferWriterReader;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class CloseProcessMessageSubscriptionCommand
extends SbeBufferWriterReader<CloseProcessMessageSubscriptionEncoder, CloseProcessMessageSubscriptionDecoder> {
    private final CloseProcessMessageSubscriptionEncoder encoder = new CloseProcessMessageSubscriptionEncoder();
    private final CloseProcessMessageSubscriptionDecoder decoder = new CloseProcessMessageSubscriptionDecoder();
    private final DirectBuffer messageName = new UnsafeBuffer(0L, 0);
    private int subscriptionPartitionId;
    private long processInstanceKey;
    private long elementInstanceKey;

    protected CloseProcessMessageSubscriptionEncoder getBodyEncoder() {
        return this.encoder;
    }

    protected CloseProcessMessageSubscriptionDecoder getBodyDecoder() {
        return this.decoder;
    }

    public void reset() {
        this.subscriptionPartitionId = CloseProcessMessageSubscriptionDecoder.subscriptionPartitionIdNullValue();
        this.processInstanceKey = CloseProcessMessageSubscriptionDecoder.processInstanceKeyNullValue();
        this.elementInstanceKey = CloseProcessMessageSubscriptionDecoder.elementInstanceKeyNullValue();
        this.messageName.wrap(0L, 0);
    }

    public int getLength() {
        return super.getLength() + CloseProcessMessageSubscriptionDecoder.messageNameHeaderLength() + this.messageName.capacity();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        super.write(buffer, offset);
        this.encoder.subscriptionPartitionId(this.subscriptionPartitionId).processInstanceKey(this.processInstanceKey).elementInstanceKey(this.elementInstanceKey).putMessageName(this.messageName, 0, this.messageName.capacity());
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        super.wrap(buffer, offset, length);
        this.subscriptionPartitionId = this.decoder.subscriptionPartitionId();
        this.processInstanceKey = this.decoder.processInstanceKey();
        this.elementInstanceKey = this.decoder.elementInstanceKey();
        this.decoder.wrapMessageName(this.messageName);
    }

    public int getSubscriptionPartitionId() {
        return this.subscriptionPartitionId;
    }

    public void setSubscriptionPartitionId(int subscriptionPartitionId) {
        this.subscriptionPartitionId = subscriptionPartitionId;
    }

    public long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    public void setProcessInstanceKey(long processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
    }

    public long getElementInstanceKey() {
        return this.elementInstanceKey;
    }

    public void setElementInstanceKey(long elementInstanceKey) {
        this.elementInstanceKey = elementInstanceKey;
    }

    public DirectBuffer getMessageName() {
        return this.messageName;
    }

    public void setMessageName(DirectBuffer messageName) {
        this.messageName.wrap(messageName);
    }
}

