/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.message;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.engine.state.ZbColumnFamilies;
import io.camunda.zeebe.engine.state.immutable.MessageStartEventSubscriptionState;
import io.camunda.zeebe.engine.state.message.MessageStartEventSubscription;
import io.camunda.zeebe.engine.state.mutable.MutableMessageStartEventSubscriptionState;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageStartEventSubscriptionRecord;
import org.agrona.DirectBuffer;

public final class DbMessageStartEventSubscriptionState
implements MutableMessageStartEventSubscriptionState {
    private final DbString messageName;
    private final DbLong processDefinitionKey;
    private final DbCompositeKey<DbString, DbLong> messageNameAndProcessDefinitionKey;
    private final ColumnFamily<DbCompositeKey<DbString, DbLong>, MessageStartEventSubscription> subscriptionsColumnFamily;
    private final MessageStartEventSubscription messageStartEventSubscription = new MessageStartEventSubscription();
    private final DbCompositeKey<DbLong, DbString> processDefinitionKeyAndMessageName;
    private final ColumnFamily<DbCompositeKey<DbLong, DbString>, DbNil> subscriptionsOfProcessDefinitionKeyColumnFamily;

    public DbMessageStartEventSubscriptionState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.messageName = new DbString();
        this.processDefinitionKey = new DbLong();
        this.messageNameAndProcessDefinitionKey = new DbCompositeKey((DbKey)this.messageName, (DbKey)this.processDefinitionKey);
        this.subscriptionsColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGE_START_EVENT_SUBSCRIPTION_BY_NAME_AND_KEY, transactionContext, this.messageNameAndProcessDefinitionKey, (DbValue)this.messageStartEventSubscription);
        this.processDefinitionKeyAndMessageName = new DbCompositeKey((DbKey)this.processDefinitionKey, (DbKey)this.messageName);
        this.subscriptionsOfProcessDefinitionKeyColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGE_START_EVENT_SUBSCRIPTION_BY_KEY_AND_NAME, transactionContext, this.processDefinitionKeyAndMessageName, (DbValue)DbNil.INSTANCE);
    }

    @Override
    public void put(long key, MessageStartEventSubscriptionRecord subscription) {
        this.messageStartEventSubscription.setKey(key).setRecord(subscription);
        this.messageName.wrapBuffer(subscription.getMessageNameBuffer());
        this.processDefinitionKey.wrapLong(subscription.getProcessDefinitionKey());
        this.subscriptionsColumnFamily.put(this.messageNameAndProcessDefinitionKey, (DbValue)this.messageStartEventSubscription);
        this.subscriptionsOfProcessDefinitionKeyColumnFamily.put(this.processDefinitionKeyAndMessageName, (DbValue)DbNil.INSTANCE);
    }

    @Override
    public void remove(long processDefinitionKey, DirectBuffer messageName) {
        this.processDefinitionKey.wrapLong(processDefinitionKey);
        this.messageName.wrapBuffer(messageName);
        this.subscriptionsColumnFamily.delete(this.messageNameAndProcessDefinitionKey);
        this.subscriptionsOfProcessDefinitionKeyColumnFamily.delete(this.processDefinitionKeyAndMessageName);
    }

    @Override
    public boolean exists(MessageStartEventSubscriptionRecord subscription) {
        this.messageName.wrapBuffer(subscription.getMessageNameBuffer());
        this.processDefinitionKey.wrapLong(subscription.getProcessDefinitionKey());
        return this.subscriptionsColumnFamily.exists(this.messageNameAndProcessDefinitionKey);
    }

    @Override
    public void visitSubscriptionsByMessageName(DirectBuffer messageName, MessageStartEventSubscriptionState.MessageStartEventSubscriptionVisitor visitor) {
        this.messageName.wrapBuffer(messageName);
        this.subscriptionsColumnFamily.whileEqualPrefix((DbKey)this.messageName, (key, value) -> visitor.visit((MessageStartEventSubscription)((Object)value)));
    }

    @Override
    public void visitSubscriptionsByProcessDefinition(long processDefinitionKey, MessageStartEventSubscriptionState.MessageStartEventSubscriptionVisitor visitor) {
        this.processDefinitionKey.wrapLong(processDefinitionKey);
        this.subscriptionsOfProcessDefinitionKeyColumnFamily.whileEqualPrefix((DbKey)this.processDefinitionKey, (key, value) -> {
            MessageStartEventSubscription subscription = (MessageStartEventSubscription)this.subscriptionsColumnFamily.get(this.messageNameAndProcessDefinitionKey);
            if (subscription != null) {
                visitor.visit(subscription);
            }
        });
    }
}

