/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.processing;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.engine.state.ZbColumnFamilies;
import io.camunda.zeebe.engine.state.mutable.MutableLastProcessedPositionState;
import io.camunda.zeebe.engine.state.processing.LastProcessedPosition;

public final class DbLastProcessedPositionState
implements MutableLastProcessedPositionState {
    private static final String LAST_PROCESSED_EVENT_KEY = "LAST_PROCESSED_EVENT_KEY";
    private static final long NO_EVENTS_PROCESSED = -1L;
    private final DbString positionKey;
    private final LastProcessedPosition position = new LastProcessedPosition();
    private final ColumnFamily<DbString, LastProcessedPosition> positionColumnFamily;

    public DbLastProcessedPositionState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.positionKey = new DbString();
        this.positionKey.wrapString(LAST_PROCESSED_EVENT_KEY);
        this.positionColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DEFAULT, transactionContext, (DbKey)this.positionKey, (DbValue)this.position);
    }

    @Override
    public long getLastSuccessfulProcessedRecordPosition() {
        LastProcessedPosition position = (LastProcessedPosition)this.positionColumnFamily.get((DbKey)this.positionKey);
        return position != null ? position.get() : -1L;
    }

    @Override
    public void markAsProcessed(long position) {
        this.position.set(position);
        this.positionColumnFamily.put((DbKey)this.positionKey, (DbValue)this.position);
    }
}

