/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.backpressure;

import com.netflix.concurrency.limits.limit.AbstractLimit;
import com.netflix.concurrency.limits.limit.Gradient2Limit;
import io.camunda.zeebe.logstreams.impl.backpressure.AlgorithmCfg;
import io.camunda.zeebe.util.Environment;

public final class AppenderGradient2Cfg
implements AlgorithmCfg {
    private int initialLimit = 1024;
    private int maxConcurrency = 32768;
    private int queueSize = 32;
    private int minLimit = 256;
    private int longWindow = 1200;
    private double rttTolerance = 1.5;

    @Override
    public void applyEnvironment(Environment environment) {
        environment.getInt("ZEEBE_BP_APPENDER_GRADIENT2_INIT_LIMIT").ifPresent(this::setInitialLimit);
        environment.getInt("ZEEBE_BP_APPENDER_GRADIENT2_MAX_CONCURRENCY").ifPresent(this::setMaxConcurrency);
        environment.getInt("ZEEBE_BP_APPENDER_GRADIENT2_QUEUE_SIZE").ifPresent(this::setQueueSize);
        environment.getInt("ZEEBE_BP_APPENDER_VEGAS_BETA_LIMIT").ifPresent(this::setMinLimit);
        environment.getInt("ZEEBE_BP_APPENDER_GRADIENT2_LONG_WINDOW").ifPresent(this::setLongWindow);
        environment.getDouble("ZEEBE_BP_APPENDER_GRADIENT2_RTT_TOLERANCE").ifPresent(this::setRttTolerance);
    }

    public int getInitialLimit() {
        return this.initialLimit;
    }

    public AppenderGradient2Cfg setInitialLimit(int initialLimit) {
        this.initialLimit = initialLimit;
        return this;
    }

    public int getMaxConcurrency() {
        return this.maxConcurrency;
    }

    public AppenderGradient2Cfg setMaxConcurrency(int maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
        return this;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public AppenderGradient2Cfg setQueueSize(int queueSize) {
        this.queueSize = queueSize;
        return this;
    }

    public int getMinLimit() {
        return this.minLimit;
    }

    public AppenderGradient2Cfg setMinLimit(int minLimit) {
        this.minLimit = minLimit;
        return this;
    }

    public int getLongWindow() {
        return this.longWindow;
    }

    public AppenderGradient2Cfg setLongWindow(int longWindow) {
        this.longWindow = longWindow;
        return this;
    }

    public double getRttTolerance() {
        return this.rttTolerance;
    }

    public AppenderGradient2Cfg setRttTolerance(double rttTolerance) {
        this.rttTolerance = rttTolerance;
        return this;
    }

    @Override
    public AbstractLimit get() {
        return Gradient2Limit.newBuilder().initialLimit(this.initialLimit).maxConcurrency(this.maxConcurrency).queueSize(this.queueSize).minLimit(this.minLimit).longWindow(this.longWindow).rttTolerance(this.rttTolerance).build();
    }

    public String toString() {
        return "AppenderGradient2Cfg{initialLimit=" + this.initialLimit + ", maxConcurrency=" + this.maxConcurrency + ", queueSize=" + this.queueSize + ", minLimit=" + this.minLimit + ", longWindow=" + this.longWindow + ", rttTolerance=" + this.rttTolerance + "}";
    }
}

