/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.event;

import com.google.common.base.Preconditions;
import io.atomix.utils.event.Event;
import io.atomix.utils.event.EventListener;
import io.atomix.utils.event.EventSink;
import io.atomix.utils.event.ListenerService;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenerRegistry<E extends Event, L extends EventListener<E>>
implements ListenerService<E, L>,
EventSink<E> {
    protected final Set<L> listeners = new CopyOnWriteArraySet<L>();
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void addListener(L listener) {
        Preconditions.checkNotNull(listener, (Object)"Listener cannot be null");
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(L listener) {
        Preconditions.checkNotNull(listener, (Object)"Listener cannot be null");
        if (!this.listeners.remove(listener)) {
            this.log.warn("Listener {} not registered", listener);
        }
    }

    @Override
    public void process(E event) {
        for (EventListener listener : this.listeners) {
            try {
                if (!listener.isRelevant(event)) continue;
                listener.event(event);
            }
            catch (Exception error) {
                this.reportProblem(event, error);
            }
        }
    }

    protected void reportProblem(E event, Throwable error) {
        this.log.warn("Exception encountered while processing event " + event, error);
    }
}

