/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.snapshots.impl;

import io.camunda.zeebe.snapshots.PersistedSnapshot;
import io.camunda.zeebe.snapshots.SnapshotId;
import io.camunda.zeebe.snapshots.TransientSnapshot;
import io.camunda.zeebe.snapshots.impl.FileBasedSnapshotMetadata;
import io.camunda.zeebe.snapshots.impl.FileBasedSnapshotStore;
import io.camunda.zeebe.snapshots.impl.SnapshotChecksum;
import io.camunda.zeebe.snapshots.impl.SnapshotMetrics;
import io.camunda.zeebe.util.FileUtil;
import io.camunda.zeebe.util.sched.ActorControl;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import io.camunda.zeebe.util.sched.future.CompletableActorFuture;
import io.prometheus.client.Histogram;
import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileBasedTransientSnapshot
implements TransientSnapshot {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileBasedTransientSnapshot.class);
    private final Path directory;
    private final ActorControl actor;
    private final FileBasedSnapshotStore snapshotStore;
    private final FileBasedSnapshotMetadata metadata;
    private final ActorFuture<Boolean> takenFuture = new CompletableActorFuture();
    private boolean isValid = false;
    private PersistedSnapshot snapshot;
    private long checksum;

    FileBasedTransientSnapshot(FileBasedSnapshotMetadata metadata, Path directory, FileBasedSnapshotStore snapshotStore, ActorControl actor) {
        this.metadata = metadata;
        this.snapshotStore = snapshotStore;
        this.directory = directory;
        this.actor = actor;
    }

    @Override
    public ActorFuture<Boolean> take(Predicate<Path> takeSnapshot) {
        this.actor.run(() -> this.takeInternal(takeSnapshot));
        return this.takenFuture;
    }

    private void takeInternal(Predicate<Path> takeSnapshot) {
        SnapshotMetrics snapshotMetrics = this.snapshotStore.getSnapshotMetrics();
        try (Histogram.Timer ignored = snapshotMetrics.startTimer();){
            try {
                this.isValid = takeSnapshot.test(this.getPath());
                if (!this.isValid) {
                    this.abortInternal();
                } else if (!this.directory.toFile().exists() || this.directory.toFile().listFiles().length == 0) {
                    this.isValid = false;
                } else {
                    this.checksum = SnapshotChecksum.calculate(this.directory);
                }
                this.snapshot = null;
                this.takenFuture.complete((Object)this.isValid);
            }
            catch (Exception exception) {
                LOGGER.warn("Unexpected exception on taking snapshot ({})", (Object)this.metadata, (Object)exception);
                this.abortInternal();
                this.takenFuture.completeExceptionally((Throwable)exception);
            }
        }
    }

    @Override
    public ActorFuture<Void> abort() {
        CompletableActorFuture abortFuture = new CompletableActorFuture();
        this.actor.run(() -> {
            this.abortInternal();
            abortFuture.complete(null);
        });
        return abortFuture;
    }

    @Override
    public ActorFuture<PersistedSnapshot> persist() {
        CompletableActorFuture future = new CompletableActorFuture();
        this.actor.call(() -> this.persistInternal((CompletableActorFuture<PersistedSnapshot>)future));
        return future;
    }

    @Override
    public SnapshotId snapshotId() {
        return this.metadata;
    }

    @Override
    public Path getPath() {
        return this.directory;
    }

    private void persistInternal(CompletableActorFuture<PersistedSnapshot> future) {
        if (this.snapshot != null) {
            future.complete((Object)this.snapshot);
            return;
        }
        if (!this.takenFuture.isDone()) {
            future.completeExceptionally((Throwable)new IllegalStateException("Snapshot is not taken"));
            return;
        }
        if (!this.isValid) {
            future.completeExceptionally((Throwable)new IllegalStateException("Snapshot is not valid. It may have been deleted."));
            return;
        }
        try {
            this.snapshot = this.snapshotStore.newSnapshot(this.metadata, this.directory, this.checksum);
            future.complete((Object)this.snapshot);
        }
        catch (Exception e) {
            future.completeExceptionally((Throwable)e);
        }
        this.snapshotStore.removePendingSnapshot(this);
    }

    private void abortInternal() {
        try {
            this.isValid = false;
            this.snapshot = null;
            LOGGER.debug("Aborting transient snapshot {}", (Object)this);
            FileUtil.deleteFolderIfExists((Path)this.directory);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to delete pending snapshot {}", (Object)this, (Object)e);
        }
        finally {
            this.snapshotStore.removePendingSnapshot(this);
        }
    }

    public String toString() {
        return "FileBasedTransientSnapshot{directory=" + this.directory + ", checksum=" + this.checksum + ", metadata=" + this.metadata + "}";
    }
}

