/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.broker.cluster;

import io.camunda.zeebe.gateway.impl.broker.cluster.BrokerClusterState;
import io.camunda.zeebe.protocol.record.PartitionHealthStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.agrona.collections.Int2IntHashMap;
import org.agrona.collections.Int2ObjectHashMap;
import org.agrona.collections.IntArrayList;

public final class BrokerClusterStateImpl
implements BrokerClusterState {
    private final Int2IntHashMap partitionLeaders = new Int2IntHashMap(-2);
    private final Int2ObjectHashMap<Long> partitionLeaderTerms = new Int2ObjectHashMap();
    private final Int2ObjectHashMap<List<Integer>> partitionFollowers = new Int2ObjectHashMap();
    private final Int2ObjectHashMap<List<Integer>> partitionInactiveNodes = new Int2ObjectHashMap();
    private final Int2ObjectHashMap<Int2ObjectHashMap<PartitionHealthStatus>> partitionsHealthPerBroker = new Int2ObjectHashMap();
    private final Int2ObjectHashMap<String> brokerAddresses = new Int2ObjectHashMap();
    private final Int2ObjectHashMap<String> brokerVersions = new Int2ObjectHashMap();
    private final IntArrayList brokers = new IntArrayList(5, -2);
    private final IntArrayList partitions = new IntArrayList(32, -3);
    private final Random randomBroker = new Random();
    private int clusterSize;
    private int partitionsCount;
    private int replicationFactor;

    public BrokerClusterStateImpl(BrokerClusterStateImpl topology) {
        this();
        if (topology != null) {
            this.partitionLeaders.putAll((Map)topology.partitionLeaders);
            this.partitionLeaderTerms.putAll(topology.partitionLeaderTerms);
            this.partitionFollowers.putAll(topology.partitionFollowers);
            this.partitionsHealthPerBroker.putAll(topology.partitionsHealthPerBroker);
            this.brokerAddresses.putAll(topology.brokerAddresses);
            this.brokerVersions.putAll(topology.brokerVersions);
            this.partitionInactiveNodes.putAll(topology.partitionInactiveNodes);
            this.brokers.addAll((Collection)topology.brokers);
            this.partitions.addAll((Collection)topology.partitions);
            this.clusterSize = topology.clusterSize;
            this.partitionsCount = topology.partitionsCount;
            this.replicationFactor = topology.replicationFactor;
        }
    }

    public BrokerClusterStateImpl() {
    }

    public void setPartitionLeader(int partitionId, int leaderId, long term) {
        if ((Long)this.partitionLeaderTerms.getOrDefault((Object)partitionId, (Object)-1L) <= term) {
            List inactives;
            this.partitionLeaders.put(partitionId, leaderId);
            this.partitionLeaderTerms.put(partitionId, (Object)term);
            List followers = (List)this.partitionFollowers.get(partitionId);
            if (followers != null) {
                followers.removeIf(follower -> follower == leaderId);
            }
            if ((inactives = (List)this.partitionInactiveNodes.get(partitionId)) != null) {
                inactives.removeIf(inactive -> inactive == leaderId);
            }
        }
    }

    public void setPartitionHealthStatus(int brokerId, int partitionId, PartitionHealthStatus status) {
        Int2ObjectHashMap partitionsHealth = (Int2ObjectHashMap)this.partitionsHealthPerBroker.computeIfAbsent(brokerId, integer -> new Int2ObjectHashMap());
        partitionsHealth.put(partitionId, (Object)status);
    }

    public void addPartitionFollower(int partitionId, int followerId) {
        ((List)this.partitionFollowers.computeIfAbsent(partitionId, ArrayList::new)).add(followerId);
        this.partitionLeaders.remove((Object)partitionId, (Object)followerId);
        List inactives = (List)this.partitionInactiveNodes.get(partitionId);
        if (inactives != null) {
            inactives.removeIf(inactive -> inactive == followerId);
        }
    }

    public void addPartitionInactive(int partitionId, int brokerId) {
        ((List)this.partitionInactiveNodes.computeIfAbsent(partitionId, ArrayList::new)).add(brokerId);
        this.partitionLeaders.remove((Object)partitionId, (Object)brokerId);
        List followers = (List)this.partitionFollowers.get(partitionId);
        if (followers != null) {
            followers.removeIf(follower -> follower == brokerId);
        }
    }

    public void addPartitionIfAbsent(int partitionId) {
        if (!this.partitions.contains((Object)partitionId)) {
            this.partitions.addInt(partitionId);
        }
    }

    public void addBrokerIfAbsent(int nodeId) {
        if (this.brokerAddresses.get(nodeId) == null) {
            this.brokerAddresses.put(nodeId, (Object)"");
            this.brokerVersions.put(nodeId, (Object)"");
            this.brokers.addInt(nodeId);
        }
    }

    public void setBrokerAddressIfPresent(int brokerId, String address) {
        this.brokerAddresses.computeIfPresent((Object)brokerId, (k, v) -> address);
    }

    public void setBrokerVersionIfPresent(int brokerId, String version) {
        this.brokerVersions.computeIfPresent((Object)brokerId, (k, v) -> version);
    }

    public void removeBroker(int brokerId) {
        this.brokerAddresses.remove(brokerId);
        this.brokerVersions.remove(brokerId);
        this.brokers.removeInt(brokerId);
        this.partitions.forEachOrderedInt(partitionId -> {
            List inactive;
            List followers;
            if (this.partitionLeaders.get(partitionId) == brokerId) {
                this.partitionLeaders.remove(partitionId);
            }
            if ((followers = (List)this.partitionFollowers.get(partitionId)) != null) {
                followers.remove((Object)brokerId);
            }
            if ((inactive = (List)this.partitionInactiveNodes.get(partitionId)) != null) {
                inactive.removeIf(id -> id == brokerId);
            }
        });
    }

    @Override
    public int getClusterSize() {
        return this.clusterSize;
    }

    public void setClusterSize(int clusterSize) {
        this.clusterSize = clusterSize;
    }

    @Override
    public int getPartitionsCount() {
        return this.partitionsCount;
    }

    public void setPartitionsCount(int partitionsCount) {
        this.partitionsCount = partitionsCount;
    }

    @Override
    public int getReplicationFactor() {
        return this.replicationFactor;
    }

    public void setReplicationFactor(int replicationFactor) {
        this.replicationFactor = replicationFactor;
    }

    @Override
    public int getLeaderForPartition(int partition) {
        return this.partitionLeaders.get(partition);
    }

    @Override
    public List<Integer> getFollowersForPartition(int partition) {
        return (List)this.partitionFollowers.get(partition);
    }

    @Override
    public List<Integer> getInactiveNodesForPartition(int partition) {
        return (List)this.partitionInactiveNodes.get(partition);
    }

    @Override
    public int getRandomBroker() {
        if (this.brokers.isEmpty()) {
            return -1;
        }
        return this.brokers.get(this.randomBroker.nextInt(this.brokers.size()));
    }

    @Override
    public List<Integer> getPartitions() {
        return this.partitions;
    }

    @Override
    public List<Integer> getBrokers() {
        return this.brokers;
    }

    @Override
    public String getBrokerAddress(int brokerId) {
        return (String)this.brokerAddresses.get(brokerId);
    }

    @Override
    public int getPartition(int index) {
        if (!this.partitions.isEmpty()) {
            return this.partitions.getInt(index % this.partitions.size());
        }
        return -3;
    }

    @Override
    public String getBrokerVersion(int brokerId) {
        return (String)this.brokerVersions.get(brokerId);
    }

    @Override
    public PartitionHealthStatus getPartitionHealth(int brokerId, int partitionId) {
        Int2ObjectHashMap brokerHealthyPartitions = (Int2ObjectHashMap)this.partitionsHealthPerBroker.get(brokerId);
        if (brokerHealthyPartitions == null) {
            return PartitionHealthStatus.UNHEALTHY;
        }
        return (PartitionHealthStatus)brokerHealthyPartitions.getOrDefault((Object)partitionId, (Object)PartitionHealthStatus.UNHEALTHY);
    }

    public String toString() {
        return "BrokerClusterStateImpl{partitionLeaders=" + this.partitionLeaders + ", brokers=" + this.brokers + ", partitions=" + this.partitions + ", clusterSize=" + this.clusterSize + ", partitionsCount=" + this.partitionsCount + ", replicationFactor=" + this.replicationFactor + "}";
    }
}

