/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.configuration;

import io.camunda.zeebe.gateway.impl.configuration.ConfigurationDefaults;
import io.camunda.zeebe.gateway.impl.configuration.MembershipCfg;
import java.time.Duration;
import java.util.Objects;

public final class ClusterCfg {
    private String contactPoint = "127.0.0.1:26502";
    private Duration requestTimeout = ConfigurationDefaults.DEFAULT_REQUEST_TIMEOUT;
    private String clusterName = "zeebe-cluster";
    private String memberId = "gateway";
    private String host = "0.0.0.0";
    private int port = 26502;
    private MembershipCfg membership = new MembershipCfg();

    public String getMemberId() {
        return this.memberId;
    }

    public ClusterCfg setMemberId(String memberId) {
        this.memberId = memberId;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public ClusterCfg setHost(String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public ClusterCfg setPort(int port) {
        this.port = port;
        return this;
    }

    public String getContactPoint() {
        return this.contactPoint;
    }

    public ClusterCfg setContactPoint(String contactPoint) {
        this.contactPoint = contactPoint;
        return this;
    }

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public ClusterCfg setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public ClusterCfg setClusterName(String name) {
        this.clusterName = name;
        return this;
    }

    public MembershipCfg getMembership() {
        return this.membership;
    }

    public void setMembership(MembershipCfg membership) {
        this.membership = membership;
    }

    public int hashCode() {
        return Objects.hash(this.contactPoint, this.requestTimeout, this.clusterName, this.memberId, this.host, this.port);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterCfg that = (ClusterCfg)o;
        return this.port == that.port && Objects.equals(this.contactPoint, that.contactPoint) && Objects.equals(this.requestTimeout, that.requestTimeout) && Objects.equals(this.clusterName, that.clusterName) && Objects.equals(this.memberId, that.memberId) && Objects.equals(this.host, that.host);
    }

    public String toString() {
        return "ClusterCfg{contactPoint='" + this.contactPoint + "', requestTimeout='" + this.requestTimeout + ", clusterName='" + this.clusterName + "', memberId='" + this.memberId + "', host='" + this.host + "', port=" + this.port + "}";
    }
}

