/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.probes.health;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.ZeebeClientBuilder;
import io.camunda.zeebe.gateway.impl.configuration.GatewayCfg;
import java.time.Duration;
import java.util.Objects;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;

public class ResponsiveHealthIndicator
implements HealthIndicator {
    private final GatewayCfg gatewayCfg;
    private final Duration defaultTimeout;
    private ZeebeClient zeebeClient;

    public ResponsiveHealthIndicator(GatewayCfg gatewayCfg, Duration defaultTimeout) {
        this.gatewayCfg = Objects.requireNonNull(gatewayCfg);
        Objects.requireNonNull(defaultTimeout);
        if (defaultTimeout.toMillis() <= 0L) {
            throw new IllegalArgumentException();
        }
        this.defaultTimeout = defaultTimeout;
    }

    GatewayCfg getGatewayCfg() {
        return this.gatewayCfg;
    }

    Duration getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public Health health() {
        Health.Builder resultBuilder;
        ZeebeClient zeebeClient = this.supplyZeebeClient();
        if (zeebeClient == null) {
            resultBuilder = Health.unknown();
        } else {
            try {
                zeebeClient.newTopologyRequest().send().get();
                resultBuilder = Health.up();
            }
            catch (Throwable t) {
                resultBuilder = Health.down().withException(t);
            }
        }
        return resultBuilder.withDetail("timeOut", (Object)this.defaultTimeout).build();
    }

    ZeebeClient supplyZeebeClient() {
        if (this.zeebeClient == null && this.gatewayCfg.isInitialized()) {
            this.zeebeClient = ResponsiveHealthIndicator.createZeebeClient(this.gatewayCfg, this.defaultTimeout);
        }
        return this.zeebeClient;
    }

    static ZeebeClient createZeebeClient(GatewayCfg gatewayCfg, Duration defaultTimeout) {
        String gatewayAddress = ResponsiveHealthIndicator.getContactPoint(gatewayCfg);
        ZeebeClientBuilder clientBuilder = ZeebeClient.newClientBuilder().gatewayAddress(gatewayAddress).defaultRequestTimeout(defaultTimeout);
        clientBuilder = gatewayCfg.getSecurity().isEnabled() ? clientBuilder.caCertificatePath(gatewayCfg.getSecurity().getCertificateChainPath()) : clientBuilder.usePlaintext();
        return clientBuilder.build();
    }

    static String getContactPoint(GatewayCfg gatewayCfg) {
        String host = gatewayCfg.getNetwork().getHost();
        int port = gatewayCfg.getNetwork().getPort();
        return host + ":" + port;
    }
}

