/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.interceptors.impl;

import io.camunda.zeebe.util.jar.ThreadContextUtil;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import org.agrona.LangUtil;

public final class DecoratedInterceptor
implements ServerInterceptor {
    private final ServerInterceptor delegate;
    private final ClassLoader classLoader;

    DecoratedInterceptor(ServerInterceptor delegate, ClassLoader classLoader) {
        this.delegate = delegate;
        this.classLoader = classLoader;
    }

    public static DecoratedInterceptor decorate(ServerInterceptor interceptor) {
        return new DecoratedInterceptor(interceptor, interceptor.getClass().getClassLoader());
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        try {
            return (ServerCall.Listener)ThreadContextUtil.callWithClassLoader(() -> this.delegate.interceptCall(call, headers, next), (ClassLoader)this.classLoader);
        }
        catch (Exception e) {
            LangUtil.rethrowUnchecked((Throwable)e);
            throw new UnsupportedOperationException("Unexpectedly reached unreachable code; an exception should have been thrown beforehand");
        }
    }
}

