/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.interceptors.impl;

import io.camunda.zeebe.gateway.Loggers;
import io.camunda.zeebe.gateway.impl.configuration.InterceptorCfg;
import io.camunda.zeebe.gateway.interceptors.impl.InterceptorLoadException;
import io.camunda.zeebe.util.ReflectUtil;
import io.camunda.zeebe.util.jar.ExternalJarLoadException;
import io.camunda.zeebe.util.jar.ExternalJarRepository;
import io.grpc.ServerInterceptor;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.agrona.LangUtil;
import org.slf4j.Logger;

public final class InterceptorRepository {
    private static final Logger LOGGER = Loggers.GATEWAY_LOGGER;
    private final ExternalJarRepository jarRepository;
    private final Map<String, Class<? extends ServerInterceptor>> interceptors;
    private final Path basePath;

    public InterceptorRepository() {
        this(new HashMap<String, Class<? extends ServerInterceptor>>(), new ExternalJarRepository(), Paths.get(Optional.ofNullable(System.getProperty("basedir")).orElse("."), new String[0]));
    }

    InterceptorRepository(Map<String, Class<? extends ServerInterceptor>> interceptors, ExternalJarRepository jarRepository, Path basePath) {
        this.interceptors = interceptors;
        this.jarRepository = jarRepository;
        this.basePath = basePath;
    }

    public Map<String, Class<? extends ServerInterceptor>> getInterceptors() {
        return Collections.unmodifiableMap(this.interceptors);
    }

    public Stream<ServerInterceptor> instantiate() {
        return this.interceptors.entrySet().stream().map(entry -> this.instantiate((String)entry.getKey(), (Class)entry.getValue()));
    }

    public InterceptorRepository load(Iterable<? extends InterceptorCfg> configs) {
        for (InterceptorCfg interceptorCfg : configs) {
            try {
                this.load(interceptorCfg);
            }
            catch (Exception e) {
                LOGGER.debug("Failed to load interceptor {} with config {}", (Object)interceptorCfg.getId(), (Object)interceptorCfg);
                LangUtil.rethrowUnchecked((Throwable)e);
            }
        }
        return this;
    }

    Class<? extends ServerInterceptor> load(InterceptorCfg config) throws ExternalJarLoadException {
        Class<ServerInterceptor> interceptorClass;
        ClassLoader classLoader;
        String id = config.getId();
        if (this.interceptors.containsKey(id)) {
            return this.interceptors.get(id);
        }
        if (!config.isExternal()) {
            classLoader = this.getClass().getClassLoader();
        } else {
            Path jarPath = this.basePath.resolve(config.getJarPath());
            classLoader = this.jarRepository.load(jarPath);
        }
        try {
            Class<?> specifiedClass = classLoader.loadClass(config.getClassName());
            interceptorClass = specifiedClass.asSubclass(ServerInterceptor.class);
        }
        catch (ClassNotFoundException e) {
            throw new InterceptorLoadException(id, "cannot load specified class", e);
        }
        catch (ClassCastException e) {
            throw new InterceptorLoadException(id, "specified class does not implement ServerInterceptor", e);
        }
        this.put(id, interceptorClass);
        return interceptorClass;
    }

    private void put(String id, Class<? extends ServerInterceptor> interceptorClass) {
        this.interceptors.put(id, interceptorClass);
    }

    private ServerInterceptor instantiate(String id, Class<? extends ServerInterceptor> interceptorClass) {
        try {
            return (ServerInterceptor)ReflectUtil.newInstance(interceptorClass);
        }
        catch (Exception e) {
            throw new InterceptorLoadException(id, "cannot instantiate via the default constructor", e);
        }
    }
}

