/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.atomix.cluster.ClusterMembershipEvent;
import io.atomix.cluster.ClusterMembershipEventListener;
import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.Member;
import io.atomix.cluster.MemberId;
import io.atomix.cluster.messaging.ClusterEventService;
import io.atomix.cluster.messaging.ManagedClusterEventService;
import io.atomix.cluster.messaging.MessagingService;
import io.atomix.cluster.messaging.Subscription;
import io.atomix.utils.concurrent.Threads;
import io.atomix.utils.net.Address;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Namespaces;
import io.atomix.utils.serializer.Serializer;
import io.atomix.utils.time.LogicalTimestamp;
import io.atomix.utils.time.WallClockTimestamp;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClusterEventService
implements ManagedClusterEventService,
ClusterMembershipEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultClusterEventService.class);
    private static final Serializer SERIALIZER = Serializer.using((Namespace)new Namespace.Builder().register(Namespaces.BASIC).register(new Class[]{MemberId.class}).register(new Class[]{LogicalTimestamp.class}).register(new Class[]{WallClockTimestamp.class}).build());
    private static final String SUBSCRIPTION_PROPERTY_NAME = "event-service-topics-subscribed";
    private final ClusterMembershipService membershipService;
    private final MessagingService messagingService;
    private final MemberId localMemberId;
    private final Map<String, InternalTopic> topics = Maps.newConcurrentMap();
    private final Map<MemberId, Set<String>> remoteMemberSubscriptions = Maps.newConcurrentMap();
    private final AtomicBoolean started = new AtomicBoolean();
    private ScheduledExecutorService eventServiceExecutor;

    public DefaultClusterEventService(ClusterMembershipService membershipService, MessagingService messagingService) {
        this.membershipService = membershipService;
        this.messagingService = messagingService;
        this.localMemberId = membershipService.getLocalMember().id();
    }

    @Override
    public <M> void broadcast(String topic, M message, Function<M, byte[]> encoder) {
        byte[] payload = encoder.apply(message);
        this.getSubscriberNodes(topic).forEach(memberId -> {
            Member member = this.membershipService.getMember((MemberId)memberId);
            if (member != null && member.isReachable()) {
                this.messagingService.sendAsync(member.address(), topic, payload);
            }
        });
    }

    @Override
    public <M, R> CompletableFuture<Subscription> subscribe(String topic, Function<byte[], M> decoder, Function<M, R> handler, Function<R, byte[]> encoder, Executor executor) {
        return this.topics.computeIfAbsent(topic, t -> new InternalTopic(topic)).subscribe(decoder, handler, encoder, executor);
    }

    @Override
    public <M, R> CompletableFuture<Subscription> subscribe(String topic, Function<byte[], M> decoder, Function<M, CompletableFuture<R>> handler, Function<R, byte[]> encoder) {
        return this.topics.computeIfAbsent(topic, t -> new InternalTopic(topic)).subscribe(decoder, handler, encoder);
    }

    @Override
    public <M> CompletableFuture<Subscription> subscribe(String topic, Function<byte[], M> decoder, Consumer<M> handler, Executor executor) {
        return this.topics.computeIfAbsent(topic, t -> new InternalTopic(topic)).subscribe(decoder, handler, executor);
    }

    @Override
    public List<Subscription> getSubscriptions(String topicName) {
        InternalTopic topic = this.topics.get(topicName);
        if (topic == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(topic.localSubscriber().subscriptions());
    }

    @Override
    public Set<MemberId> getSubscribers(String topicName) {
        InternalTopic topic = this.topics.get(topicName);
        if (topic == null) {
            return Set.of();
        }
        return topic.remoteSubscriptions();
    }

    private Stream<MemberId> getSubscriberNodes(String topicName) {
        return this.getSubscribers(topicName).stream();
    }

    private CompletableFuture<Void> updateNodes() {
        String topicSubscribed = this.topicsAsString(new HashSet<String>(this.topics.keySet()));
        this.membershipService.getLocalMember().properties().setProperty(SUBSCRIPTION_PROPERTY_NAME, topicSubscribed);
        return CompletableFuture.completedFuture(null);
    }

    private String topicsAsString(Set<String> topics) {
        byte[] bytes = SERIALIZER.encode(topics);
        return new String(Base64.getEncoder().encode(bytes), StandardCharsets.UTF_8);
    }

    private Set<String> topicsFromString(String topicsAsString) {
        byte[] bytes = Base64.getDecoder().decode(topicsAsString.getBytes(StandardCharsets.UTF_8));
        return (Set)SERIALIZER.decode(bytes);
    }

    public CompletableFuture<ClusterEventService> start() {
        if (this.started.compareAndSet(false, true)) {
            this.eventServiceExecutor = Executors.newSingleThreadScheduledExecutor(Threads.namedThreads((String)"atomix-cluster-event-executor-%d", (Logger)LOGGER));
            this.membershipService.addListener(this);
            this.membershipService.getMembers().forEach(m -> this.event(new ClusterMembershipEvent(ClusterMembershipEvent.Type.MEMBER_ADDED, (Member)m)));
            LOGGER.info("Started");
        }
        return CompletableFuture.completedFuture(this);
    }

    public boolean isRunning() {
        return this.started.get();
    }

    public CompletableFuture<Void> stop() {
        if (this.started.compareAndSet(true, false)) {
            if (this.eventServiceExecutor != null) {
                this.eventServiceExecutor.shutdown();
            }
            LOGGER.info("Stopped");
        }
        return CompletableFuture.completedFuture(null);
    }

    public void event(ClusterMembershipEvent event) {
        this.eventServiceExecutor.execute(() -> {
            switch ((ClusterMembershipEvent.Type)event.type()) {
                case MEMBER_ADDED: {
                    this.updateRemoteSubscription(event);
                    break;
                }
                case METADATA_CHANGED: {
                    this.updateRemoteSubscription(event);
                    break;
                }
                case REACHABILITY_CHANGED: {
                    break;
                }
                case MEMBER_REMOVED: {
                    this.removeAllSubscription(((Member)event.subject()).id());
                    break;
                }
                default: {
                    LOGGER.warn("Unexpected membership event type {} from {}", (Object)event.type(), event.subject());
                }
            }
        });
    }

    private void removeAllSubscription(MemberId id) {
        Set<String> prevSubscriptions = this.remoteMemberSubscriptions.remove(id);
        if (prevSubscriptions != null) {
            prevSubscriptions.forEach(s -> this.topics.get(s).removeRemoteSubscription(id));
        }
    }

    private void updateRemoteSubscription(ClusterMembershipEvent event) {
        String topicSubscribedAsString = ((Member)event.subject()).properties().getProperty(SUBSCRIPTION_PROPERTY_NAME);
        if (topicSubscribedAsString != null) {
            Set<String> topicsSubscribed = this.topicsFromString(topicSubscribedAsString);
            topicsSubscribed.forEach(topic -> this.topics.computeIfAbsent((String)topic, t -> new InternalTopic((String)topic)).addRemoteSubscription(((Member)event.subject()).id()));
            this.remoteMemberSubscriptions.put(((Member)event.subject()).id(), topicsSubscribed);
        } else {
            this.removeAllSubscription(((Member)event.subject()).id());
        }
    }

    private class InternalSubscription
    implements Subscription {
        private final InternalTopic topic;
        private final Function<byte[], CompletableFuture<byte[]>> callback;

        InternalSubscription(InternalTopic topic, Function<byte[], CompletableFuture<byte[]>> callback) {
            this.topic = topic;
            this.callback = callback;
        }

        @Override
        public String topic() {
            return this.topic.topic;
        }

        @Override
        public CompletableFuture<Void> close() {
            return this.topic.removeLocalSubscription(this);
        }
    }

    private class InternalTopic {
        private final String topic;
        private final InternalSubscriber localSubscribers = new InternalSubscriber();
        private final Set<MemberId> subscriptions = Sets.newCopyOnWriteArraySet();

        InternalTopic(String topic) {
            this.topic = topic;
        }

        InternalSubscriber localSubscriber() {
            return this.localSubscribers;
        }

        Set<MemberId> remoteSubscriptions() {
            return this.subscriptions;
        }

        <M, R> CompletableFuture<Subscription> subscribe(Function<byte[], M> decoder, Function<M, R> handler, Function<R, byte[]> encoder, Executor executor) {
            return this.addLocalSubscription(new InternalSubscription(this, payload -> {
                CompletableFuture future = new CompletableFuture();
                executor.execute(() -> {
                    try {
                        future.complete((byte[])encoder.apply(handler.apply(decoder.apply((byte[])payload))));
                    }
                    catch (Exception e) {
                        future.completeExceptionally(e);
                    }
                });
                return future;
            }));
        }

        <M, R> CompletableFuture<Subscription> subscribe(Function<byte[], M> decoder, Function<M, CompletableFuture<R>> handler, Function<R, byte[]> encoder) {
            return this.addLocalSubscription(new InternalSubscription(this, payload -> ((CompletableFuture)handler.apply(decoder.apply((byte[])payload))).thenApply(encoder)));
        }

        <M> CompletableFuture<Subscription> subscribe(Function<byte[], M> decoder, Consumer<M> handler, Executor executor) {
            return this.addLocalSubscription(new InternalSubscription(this, payload -> {
                executor.execute(() -> {
                    Object decoded;
                    try {
                        decoded = decoder.apply((byte[])payload);
                    }
                    catch (RuntimeException e) {
                        LOGGER.error("Failed to decode message payload for topic {}", (Object)this.topic, (Object)e);
                        return;
                    }
                    try {
                        handler.accept(decoded);
                    }
                    catch (RuntimeException e) {
                        LOGGER.error("Failed to handle message {} for topic {}", new Object[]{decoded, this.topic, e});
                    }
                });
                return CompletableFuture.completedFuture(null);
            }));
        }

        private synchronized CompletableFuture<Subscription> addLocalSubscription(InternalSubscription subscription) {
            if (this.localSubscribers.subscriptions.isEmpty()) {
                DefaultClusterEventService.this.messagingService.registerHandler(subscription.topic(), this.localSubscribers);
            }
            this.localSubscribers.add(subscription);
            this.subscriptions.add(DefaultClusterEventService.this.localMemberId);
            return DefaultClusterEventService.this.updateNodes().thenApply(v -> subscription);
        }

        private synchronized CompletableFuture<Void> removeLocalSubscription(InternalSubscription subscription) {
            this.localSubscribers.remove(subscription);
            if (this.localSubscribers.subscriptions.isEmpty()) {
                this.subscriptions.remove(DefaultClusterEventService.this.localMemberId);
                DefaultClusterEventService.this.messagingService.unregisterHandler(subscription.topic());
            }
            return DefaultClusterEventService.this.updateNodes();
        }

        void addRemoteSubscription(MemberId subscription) {
            this.subscriptions.add(subscription);
        }

        void removeRemoteSubscription(MemberId subscription) {
            this.subscriptions.remove(subscription);
        }
    }

    private static class InternalSubscriber
    implements BiFunction<Address, byte[], CompletableFuture<byte[]>> {
        private final List<InternalSubscription> subscriptions = new CopyOnWriteArrayList<InternalSubscription>();

        private InternalSubscriber() {
        }

        List<InternalSubscription> subscriptions() {
            return ImmutableList.copyOf(this.subscriptions);
        }

        @Override
        public CompletableFuture<byte[]> apply(Address address, byte[] payload) {
            for (InternalSubscription s : this.subscriptions) {
                s.callback.apply(payload);
            }
            return CompletableFuture.completedFuture(null);
        }

        void add(InternalSubscription subscription) {
            this.subscriptions.add(subscription);
        }

        void remove(InternalSubscription subscription) {
            this.subscriptions.remove(subscription);
        }
    }
}

