/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.roles;

import com.google.common.base.Preconditions;
import io.atomix.raft.RaftServer;
import io.atomix.raft.cluster.impl.DefaultRaftMember;
import io.atomix.raft.cluster.impl.RaftMemberContext;
import io.atomix.raft.impl.RaftContext;
import io.atomix.raft.metrics.LeaderMetrics;
import io.atomix.raft.protocol.AppendRequest;
import io.atomix.raft.protocol.AppendResponse;
import io.atomix.raft.protocol.ConfigureRequest;
import io.atomix.raft.protocol.ConfigureResponse;
import io.atomix.raft.protocol.InstallRequest;
import io.atomix.raft.protocol.InstallResponse;
import io.atomix.raft.protocol.RaftRequest;
import io.atomix.raft.protocol.RaftResponse;
import io.atomix.raft.snapshot.impl.SnapshotChunkImpl;
import io.atomix.raft.storage.log.IndexedRaftLogEntry;
import io.atomix.raft.storage.log.PersistedRaftRecord;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import io.camunda.zeebe.snapshots.PersistedSnapshot;
import io.camunda.zeebe.snapshots.SnapshotChunk;
import io.camunda.zeebe.snapshots.SnapshotChunkReader;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.slf4j.Logger;

abstract class AbstractAppender
implements AutoCloseable {
    protected final int maxBatchSizePerAppend;
    protected final Logger log;
    protected final RaftContext raft;
    protected boolean open = true;
    private final LeaderMetrics metrics;

    AbstractAppender(RaftContext raft) {
        this.raft = (RaftContext)Preconditions.checkNotNull((Object)raft, (Object)"context cannot be null");
        this.log = ContextualLoggerFactory.getLogger(this.getClass(), (LoggerContext)LoggerContext.builder(RaftServer.class).addValue((Object)raft.getName()).build());
        this.metrics = new LeaderMetrics(raft.getName());
        this.maxBatchSizePerAppend = raft.getMaxAppendBatchSize();
    }

    protected AppendRequest buildAppendRequest(RaftMemberContext member, long lastIndex) {
        if (!member.hasNextEntry()) {
            return this.buildAppendEmptyRequest(member);
        }
        if (member.getFailureCount() > 0) {
            return this.buildAppendEmptyRequest(member);
        }
        return this.buildAppendEntriesRequest(member, lastIndex);
    }

    protected AppendRequest buildAppendEmptyRequest(RaftMemberContext member) {
        IndexedRaftLogEntry prevEntry = member.getCurrentEntry();
        DefaultRaftMember leader = this.raft.getLeader();
        return this.builderWithPreviousEntry(prevEntry).withTerm(this.raft.getTerm()).withLeader(leader.memberId()).withEntries(Collections.emptyList()).withCommitIndex(this.raft.getCommitIndex()).build();
    }

    private AppendRequest.Builder builderWithPreviousEntry(IndexedRaftLogEntry prevEntry) {
        long prevIndex = 0L;
        long prevTerm = 0L;
        if (prevEntry != null) {
            prevIndex = prevEntry.index();
            prevTerm = prevEntry.term();
        } else {
            PersistedSnapshot currentSnapshot = this.raft.getCurrentSnapshot();
            if (currentSnapshot != null) {
                prevIndex = currentSnapshot.getIndex();
                prevTerm = currentSnapshot.getTerm();
            }
        }
        return AppendRequest.builder().withPrevLogTerm(prevTerm).withPrevLogIndex(prevIndex);
    }

    protected AppendRequest buildAppendEntriesRequest(RaftMemberContext member, long lastIndex) {
        IndexedRaftLogEntry prevEntry = member.getCurrentEntry();
        DefaultRaftMember leader = this.raft.getLeader();
        AppendRequest.Builder builder = this.builderWithPreviousEntry(prevEntry).withTerm(this.raft.getTerm()).withLeader(leader.memberId()).withCommitIndex(this.raft.getCommitIndex());
        ArrayList<PersistedRaftRecord> entries = new ArrayList<PersistedRaftRecord>();
        int size = 0;
        while (member.hasNextEntry()) {
            IndexedRaftLogEntry entry = member.nextEntry();
            PersistedRaftRecord replicatableRecord = entry.getPersistedRaftRecord();
            entries.add(replicatableRecord);
            if (entry.index() != lastIndex && (size += replicatableRecord.approximateSize()) < this.maxBatchSizePerAppend) continue;
            break;
        }
        return builder.withEntries(entries).build();
    }

    protected void sendAppendRequest(RaftMemberContext member, AppendRequest request) {
        if (request.entries().isEmpty() && !member.canHeartbeat()) {
            return;
        }
        member.startAppend();
        long timestamp = System.currentTimeMillis();
        this.log.trace("Sending {} to {}", (Object)request, (Object)member.getMember().memberId());
        this.raft.getProtocol().append(member.getMember().memberId(), request).whenCompleteAsync((response, error) -> {
            long appendLatency = System.currentTimeMillis() - timestamp;
            this.metrics.appendComplete(appendLatency, (String)((Object)member.getMember().memberId().id()));
            if (!request.entries().isEmpty()) {
                member.completeAppend(appendLatency);
            } else {
                member.completeAppend();
            }
            if (this.open) {
                if (error == null) {
                    this.log.trace("Received {} from {}", response, (Object)member.getMember().memberId());
                    this.handleAppendResponse(member, request, (AppendResponse)response, timestamp);
                } else {
                    this.handleAppendResponseFailure(member, request, (Throwable)error);
                }
            }
        }, (Executor)this.raft.getThreadContext());
        if (!request.entries().isEmpty() && this.hasMoreEntries(member)) {
            this.appendEntries(member);
        }
    }

    protected void handleAppendResponseFailure(RaftMemberContext member, AppendRequest request, Throwable error) {
        this.failAttempt(member, request, error);
    }

    protected void failAttempt(RaftMemberContext member, RaftRequest request, Throwable error) {
        int failures = member.incrementFailureCount();
        if (failures <= 3 || failures % 100 == 0) {
            this.log.warn("{} to {} failed: {}", new Object[]{request, member.getMember().memberId(), error});
        }
    }

    protected void handleAppendResponse(RaftMemberContext member, AppendRequest request, AppendResponse response, long timestamp) {
        if (response.status() == RaftResponse.Status.OK) {
            this.handleAppendResponseOk(member, request, response);
        } else {
            this.handleAppendResponseError(member, request, response);
        }
    }

    protected void handleAppendResponseOk(RaftMemberContext member, AppendRequest request, AppendResponse response) {
        this.succeedAttempt(member);
        if (response.succeeded()) {
            this.updateMatchIndex(member, response);
            if (request.prevLogIndex() != response.lastLogIndex() && this.hasMoreEntries(member)) {
                this.appendEntries(member);
            }
        } else if (response.term() > this.raft.getTerm()) {
            this.log.info("Received higher term ({} > {}) from {}, stepping down", new Object[]{response.term(), this.raft.getTerm(), member.getMember()});
            this.raft.setTerm(response.term());
            this.raft.setLeader(null);
            this.raft.transition(RaftServer.Role.FOLLOWER);
        } else {
            this.resetMatchIndex(member, response);
            this.resetNextIndex(member, response);
            this.resetSnapshotIndex(member, response);
            if (response.lastLogIndex() != request.prevLogIndex() && this.hasMoreEntries(member)) {
                this.appendEntries(member);
            }
        }
    }

    protected abstract void appendEntries(RaftMemberContext var1);

    protected void succeedAttempt(RaftMemberContext member) {
        member.resetFailureCount();
    }

    protected abstract boolean hasMoreEntries(RaftMemberContext var1);

    protected void updateMatchIndex(RaftMemberContext member, AppendResponse response) {
        member.setMatchIndex(response.lastLogIndex());
    }

    protected void resetMatchIndex(RaftMemberContext member, AppendResponse response) {
        if (response.lastLogIndex() < member.getMatchIndex()) {
            member.setMatchIndex(response.lastLogIndex());
            this.log.trace("Reset match index for {} to {}", (Object)member, (Object)member.getMatchIndex());
        }
    }

    protected void resetNextIndex(RaftMemberContext member, AppendResponse response) {
        long nextIndex = response.lastLogIndex() + 1L;
        this.resetNextIndex(member, nextIndex);
    }

    private void resetNextIndex(RaftMemberContext member, long nextIndex) {
        member.reset(nextIndex);
        this.log.trace("Reset next index for {} to {}", (Object)member, (Object)nextIndex);
    }

    protected void resetSnapshotIndex(RaftMemberContext member, AppendResponse response) {
        long snapshotIndex = response.lastSnapshotIndex();
        if (member.getSnapshotIndex() != snapshotIndex) {
            member.setSnapshotIndex(snapshotIndex);
            this.log.trace("Reset snapshot index for {} to {}", (Object)member, (Object)snapshotIndex);
        }
    }

    protected void handleAppendResponseError(RaftMemberContext member, AppendRequest request, AppendResponse response) {
        int failures = member.incrementFailureCount();
        if (failures <= 3 || failures % 100 == 0) {
            this.log.warn("{} to {} failed: {}", new Object[]{request, member.getMember().memberId(), response.error() != null ? response.error() : ""});
        }
    }

    protected ConfigureRequest buildConfigureRequest() {
        DefaultRaftMember leader = this.raft.getLeader();
        return ConfigureRequest.builder().withTerm(this.raft.getTerm()).withLeader(leader.memberId()).withIndex(this.raft.getCluster().getConfiguration().index()).withTime(this.raft.getCluster().getConfiguration().time()).withMembers(this.raft.getCluster().getConfiguration().members()).build();
    }

    protected void sendConfigureRequest(RaftMemberContext member, ConfigureRequest request) {
        this.log.debug("Configuring {}", (Object)member.getMember().memberId());
        member.startConfigure();
        long timestamp = System.currentTimeMillis();
        this.log.trace("Sending {} to {}", (Object)request, (Object)member.getMember().memberId());
        this.raft.getProtocol().configure(member.getMember().memberId(), request).whenCompleteAsync((response, error) -> {
            member.completeConfigure();
            if (this.open) {
                if (error == null) {
                    this.log.trace("Received {} from {}", response, (Object)member.getMember().memberId());
                    this.handleConfigureResponse(member, request, (ConfigureResponse)response, timestamp);
                } else {
                    if (this.log.isTraceEnabled()) {
                        this.log.debug("Failed to configure {}", (Object)member.getMember().memberId(), error);
                    } else {
                        this.log.debug("Failed to configure {}", (Object)member.getMember().memberId());
                    }
                    this.handleConfigureResponseFailure(member, request, (Throwable)error);
                }
            }
        }, (Executor)this.raft.getThreadContext());
    }

    protected void handleConfigureResponseFailure(RaftMemberContext member, ConfigureRequest request, Throwable error) {
        this.failAttempt(member, request, error);
    }

    protected void handleConfigureResponse(RaftMemberContext member, ConfigureRequest request, ConfigureResponse response, long timestamp) {
        if (response.status() == RaftResponse.Status.OK) {
            this.handleConfigureResponseOk(member, request, response);
        } else {
            this.handleConfigureResponseError(member, request, response);
        }
    }

    protected void handleConfigureResponseOk(RaftMemberContext member, ConfigureRequest request, ConfigureResponse response) {
        this.succeedAttempt(member);
        member.setConfigTerm(request.term());
        member.setConfigIndex(request.index());
        this.appendEntries(member);
    }

    protected void handleConfigureResponseError(RaftMemberContext member, ConfigureRequest request, ConfigureResponse response) {
    }

    protected Optional<InstallRequest> buildInstallRequest(RaftMemberContext member, PersistedSnapshot persistedSnapshot) {
        SnapshotChunkReader reader;
        if (member.getNextSnapshotIndex() != persistedSnapshot.getIndex()) {
            try {
                SnapshotChunkReader snapshotChunkReader = persistedSnapshot.newChunkReader();
                member.setSnapshotChunkReader(snapshotChunkReader);
            }
            catch (UncheckedIOException e) {
                this.log.warn("Expected to send Snapshot {} to {}. But could not open SnapshotChunkReader. Will retry.", (Object)persistedSnapshot.getId(), (Object)e);
                return Optional.empty();
            }
            member.setNextSnapshotIndex(persistedSnapshot.getIndex());
            member.setNextSnapshotChunk(null);
        }
        if (!(reader = member.getSnapshotChunkReader()).hasNext()) {
            return Optional.empty();
        }
        try {
            SnapshotChunk chunk = (SnapshotChunk)reader.next();
            DefaultRaftMember leader = this.raft.getLeader();
            InstallRequest request = InstallRequest.builder().withCurrentTerm(this.raft.getTerm()).withLeader(leader.memberId()).withIndex(persistedSnapshot.getIndex()).withTerm(persistedSnapshot.getTerm()).withVersion(persistedSnapshot.version()).withData(new SnapshotChunkImpl(chunk).toByteBuffer()).withChunkId(ByteBuffer.wrap(chunk.getChunkName().getBytes())).withInitial(member.getNextSnapshotChunk() == null).withComplete(!reader.hasNext()).withNextChunkId(reader.nextId()).build();
            return Optional.of(request);
        }
        catch (UncheckedIOException e) {
            this.log.warn("Expected to send next chunk of Snapshot {} to {}. But could not read SnapshotChunk. Snapshot may have been deleted. Will retry.", new Object[]{persistedSnapshot.getId(), member.getMember().memberId(), e});
            member.setNextSnapshotIndex(0L);
            return Optional.empty();
        }
    }

    protected void sendInstallRequest(RaftMemberContext member, InstallRequest request) {
        member.startInstall();
        long timestamp = System.currentTimeMillis();
        this.log.trace("Sending {} to {}", (Object)request, (Object)member.getMember().memberId());
        this.raft.getProtocol().install(member.getMember().memberId(), request).whenCompleteAsync((response, error) -> {
            member.completeInstall();
            if (this.open) {
                if (error == null) {
                    this.log.trace("Received {} from {}", response, (Object)member.getMember().memberId());
                    this.handleInstallResponse(member, request, (InstallResponse)response, timestamp);
                } else {
                    this.handleInstallResponseFailure(member, request, (Throwable)error);
                }
            }
        }, (Executor)this.raft.getThreadContext());
    }

    protected void handleInstallResponseFailure(RaftMemberContext member, InstallRequest request, Throwable error) {
        member.setNextSnapshotIndex(0L);
        member.setNextSnapshotChunk(null);
        this.failAttempt(member, request, error);
    }

    protected void handleInstallResponse(RaftMemberContext member, InstallRequest request, InstallResponse response, long timestamp) {
        if (response.status() == RaftResponse.Status.OK) {
            this.handleInstallResponseOk(member, request, response);
        } else {
            this.handleInstallResponseError(member, request, response);
        }
    }

    protected void handleInstallResponseOk(RaftMemberContext member, InstallRequest request, InstallResponse response) {
        this.succeedAttempt(member);
        if (request.complete()) {
            member.setNextSnapshotIndex(0L);
            member.setNextSnapshotChunk(null);
            member.setSnapshotIndex(request.index());
            this.resetNextIndex(member, request.index() + 1L);
        } else {
            member.setNextSnapshotChunk(request.nextChunkId());
        }
        this.appendEntries(member);
    }

    protected void handleInstallResponseError(RaftMemberContext member, InstallRequest request, InstallResponse response) {
        this.log.warn("Failed to send {} to member {}, with {}. Restart sending snapshot.", new Object[]{request, member.getMember().memberId(), response.error().toString()});
        member.setNextSnapshotIndex(0L);
        member.setNextSnapshotChunk(null);
    }

    @Override
    public void close() {
        this.open = false;
    }
}

