/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.storage.serializer;

import io.atomix.raft.storage.serializer.EntryType;
import io.atomix.raft.storage.serializer.MessageHeaderDecoder;
import io.atomix.raft.storage.serializer.MetaAttribute;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public final class RaftLogEntryDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 9;
    public static final int TEMPLATE_ID = 1;
    public static final int SCHEMA_ID = 8;
    public static final int SCHEMA_VERSION = 1;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final RaftLogEntryDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 9;
    }

    public int sbeTemplateId() {
        return 1;
    }

    public int sbeSchemaId() {
        return 8;
    }

    public int sbeSchemaVersion() {
        return 1;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public RaftLogEntryDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public RaftLogEntryDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (1 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public RaftLogEntryDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int termId() {
        return 0;
    }

    public static int termSinceVersion() {
        return 0;
    }

    public static int termEncodingOffset() {
        return 0;
    }

    public static int termEncodingLength() {
        return 8;
    }

    public static String termMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long termNullValue() {
        return -1L;
    }

    public static long termMinValue() {
        return 0L;
    }

    public static long termMaxValue() {
        return -2L;
    }

    public long term() {
        return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int typeId() {
        return 1;
    }

    public static int typeSinceVersion() {
        return 0;
    }

    public static int typeEncodingOffset() {
        return 8;
    }

    public static int typeEncodingLength() {
        return 1;
    }

    public static String typeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public short typeRaw() {
        return (short)(this.buffer.getByte(this.offset + 8) & 0xFF);
    }

    public EntryType type() {
        return EntryType.get((short)(this.buffer.getByte(this.offset + 8) & 0xFF));
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        RaftLogEntryDecoder decoder = new RaftLogEntryDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[RaftLogEntry](sbeTemplateId=");
        builder.append(1);
        builder.append("|sbeSchemaId=");
        builder.append(8);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 1) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(1);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 9) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(9);
        builder.append("):");
        builder.append("term=");
        builder.append(this.term());
        builder.append('|');
        builder.append("type=");
        builder.append((Object)this.type());
        this.limit(originalLimit);
        return builder;
    }
}

