/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway;

import io.atomix.cluster.AtomixCluster;
import io.atomix.cluster.discovery.BootstrapDiscoveryProvider;
import io.atomix.cluster.protocol.GroupMembershipProtocol;
import io.atomix.cluster.protocol.SwimMembershipProtocol;
import io.atomix.utils.net.Address;
import io.camunda.zeebe.gateway.Gateway;
import io.camunda.zeebe.gateway.Loggers;
import io.camunda.zeebe.gateway.impl.SpringGatewayBridge;
import io.camunda.zeebe.gateway.impl.broker.BrokerClient;
import io.camunda.zeebe.gateway.impl.broker.BrokerClientImpl;
import io.camunda.zeebe.gateway.impl.broker.cluster.BrokerTopologyManager;
import io.camunda.zeebe.gateway.impl.configuration.ClusterCfg;
import io.camunda.zeebe.gateway.impl.configuration.GatewayCfg;
import io.camunda.zeebe.gateway.impl.configuration.MembershipCfg;
import io.camunda.zeebe.util.VersionUtil;
import io.camunda.zeebe.util.sched.ActorScheduler;
import io.camunda.zeebe.util.sched.ActorSchedulingService;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.elasticsearch.ElasticsearchRestClientAutoConfiguration;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.event.ContextClosedEvent;

@SpringBootApplication(exclude={ElasticsearchRestClientAutoConfiguration.class})
@ComponentScan(value={"io.camunda.zeebe.gateway", "io.camunda.zeebe.shared", "io.camunda.zeebe.util"})
public class StandaloneGateway
implements CommandLineRunner,
ApplicationListener<ContextClosedEvent> {
    private static final Logger LOG = Loggers.GATEWAY_LOGGER;
    private final GatewayCfg configuration;
    private final SpringGatewayBridge springGatewayBridge;
    private AtomixCluster atomixCluster;
    private Gateway gateway;
    private ActorScheduler actorScheduler;

    @Autowired
    public StandaloneGateway(GatewayCfg configuration, SpringGatewayBridge springGatewayBridge) {
        this.configuration = configuration;
        this.springGatewayBridge = springGatewayBridge;
    }

    public static void main(String[] args) {
        System.setProperty("spring.banner.location", "classpath:/assets/zeebe_gateway_banner.txt");
        SpringApplication.run(StandaloneGateway.class, (String[])args);
    }

    public void run(String ... args) throws Exception {
        this.configuration.init();
        if (LOG.isInfoEnabled()) {
            LOG.info("Version: {}", (Object)VersionUtil.getVersion());
            LOG.info("Starting standalone gateway with configuration {}", (Object)this.configuration.toJson());
        }
        this.atomixCluster = this.createAtomixCluster(this.configuration.getCluster());
        this.actorScheduler = this.createActorScheduler(this.configuration);
        this.gateway = new Gateway(this.configuration, this::createBrokerClient, (ActorSchedulingService)this.actorScheduler);
        this.springGatewayBridge.registerGatewayStatusSupplier(() -> ((Gateway)this.gateway).getStatus());
        this.springGatewayBridge.registerClusterStateSupplier(() -> Optional.ofNullable(this.gateway.getBrokerClient()).map(BrokerClient::getTopologyManager).map(BrokerTopologyManager::getTopology));
        this.actorScheduler.start();
        this.atomixCluster.start();
        this.gateway.start();
    }

    public void onApplicationEvent(ContextClosedEvent event) {
        try {
            this.gateway.stop();
        }
        catch (Exception e) {
            LOG.warn("Failed to gracefully shutdown gRPC gateway", (Throwable)e);
        }
        try {
            this.atomixCluster.stop().orTimeout(10L, TimeUnit.SECONDS).join();
        }
        catch (Exception e) {
            LOG.warn("Failed to gracefully shutdown cluster services", (Throwable)e);
        }
        try {
            this.actorScheduler.close();
        }
        catch (Exception e) {
            LOG.warn("Failed to gracefully shutdown actor scheduler", (Throwable)e);
        }
        LogManager.shutdown();
    }

    private BrokerClient createBrokerClient(GatewayCfg config) {
        return new BrokerClientImpl(config, this.atomixCluster.getMessagingService(), this.atomixCluster.getMembershipService(), this.atomixCluster.getEventService(), this.actorScheduler, false);
    }

    private AtomixCluster createAtomixCluster(ClusterCfg config) {
        GroupMembershipProtocol membershipProtocol = this.createMembershipProtocol(config.getMembership());
        return AtomixCluster.builder().withMemberId(config.getMemberId()).withAddress(Address.from((String)config.getHost(), (int)config.getPort())).withClusterId(config.getClusterName()).withMembershipProvider(BootstrapDiscoveryProvider.builder().withNodes(new Address[]{Address.from((String)config.getContactPoint())}).build()).withMembershipProtocol(membershipProtocol).build();
    }

    private GroupMembershipProtocol createMembershipProtocol(MembershipCfg config) {
        return SwimMembershipProtocol.builder().withFailureTimeout(config.getFailureTimeout()).withGossipInterval(config.getGossipInterval()).withProbeInterval(config.getProbeInterval()).withProbeTimeout(config.getProbeTimeout()).withBroadcastDisputes(config.isBroadcastDisputes()).withBroadcastUpdates(config.isBroadcastUpdates()).withGossipFanout(config.getGossipFanout()).withNotifySuspect(config.isNotifySuspect()).withSuspectProbes(config.getSuspectProbes()).withSyncInterval(config.getSyncInterval()).build();
    }

    private ActorScheduler createActorScheduler(GatewayCfg config) {
        return ActorScheduler.newActorScheduler().setCpuBoundActorThreadCount(config.getThreads().getManagementThreads()).setIoBoundActorThreadCount(0).setSchedulerName("gateway-scheduler").build();
    }
}

