/*
 * Decompiled with CFR 0.152.
 */
package me.dinowernli.grpc.prometheus;

import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Histogram;
import io.prometheus.client.SimpleCollector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import me.dinowernli.grpc.prometheus.Configuration;
import me.dinowernli.grpc.prometheus.GrpcMethod;

class ClientMetrics {
    private static final Counter.Builder rpcStartedBuilder = (Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("grpc")).subsystem("client")).name("started_total")).labelNames(new String[]{"grpc_type", "grpc_service", "grpc_method"})).help("Total number of RPCs started on the client.");
    private static final Counter.Builder rpcCompletedBuilder = (Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("grpc")).subsystem("client")).name("completed")).labelNames(new String[]{"grpc_type", "grpc_service", "grpc_method", "code"})).help("Total number of RPCs completed on the client, regardless of success or failure.");
    private static final Histogram.Builder completedLatencySecondsBuilder = (Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("grpc")).subsystem("client")).name("completed_latency_seconds")).labelNames(new String[]{"grpc_type", "grpc_service", "grpc_method"})).help("Histogram of rpc response latency (in seconds) for completed rpcs.");
    private static final Counter.Builder streamMessagesReceivedBuilder = (Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("grpc")).subsystem("client")).name("msg_received_total")).labelNames(new String[]{"grpc_type", "grpc_service", "grpc_method"})).help("Total number of stream messages received from the server.");
    private static final Counter.Builder streamMessagesSentBuilder = (Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("grpc")).subsystem("client")).name("msg_sent_total")).labelNames(new String[]{"grpc_type", "grpc_service", "grpc_method"})).help("Total number of stream messages sent by the client.");
    private final Counter rpcStarted;
    private final Counter rpcCompleted;
    private final Counter streamMessagesReceived;
    private final Counter streamMessagesSent;
    private final Optional<Histogram> completedLatencySeconds;
    private final GrpcMethod method;

    private ClientMetrics(GrpcMethod grpcMethod, Counter counter, Counter counter2, Counter counter3, Counter counter4, Optional<Histogram> optional) {
        this.method = grpcMethod;
        this.rpcStarted = counter;
        this.rpcCompleted = counter2;
        this.streamMessagesReceived = counter3;
        this.streamMessagesSent = counter4;
        this.completedLatencySeconds = optional;
    }

    public void recordCallStarted() {
        ((Counter.Child)this.addLabels((SimpleCollector)this.rpcStarted, new String[0])).inc();
    }

    public void recordClientHandled(Status.Code code) {
        ((Counter.Child)this.addLabels((SimpleCollector)this.rpcCompleted, code.toString())).inc();
    }

    public void recordStreamMessageSent() {
        ((Counter.Child)this.addLabels((SimpleCollector)this.streamMessagesSent, new String[0])).inc();
    }

    public void recordStreamMessageReceived() {
        ((Counter.Child)this.addLabels((SimpleCollector)this.streamMessagesReceived, new String[0])).inc();
    }

    public void recordLatency(double d) {
        if (!this.completedLatencySeconds.isPresent()) {
            return;
        }
        ((Histogram.Child)this.addLabels((SimpleCollector)this.completedLatencySeconds.get(), new String[0])).observe(d);
    }

    private <T> T addLabels(SimpleCollector<T> simpleCollector, String ... stringArray) {
        ArrayList arrayList = new ArrayList();
        Collections.addAll(arrayList, this.method.type(), this.method.serviceName(), this.method.methodName());
        Collections.addAll(arrayList, stringArray);
        return (T)simpleCollector.labels(arrayList.toArray(new String[0]));
    }

    static class Factory {
        private final Counter rpcStarted;
        private final Counter rpcCompleted;
        private final Counter streamMessagesReceived;
        private final Counter streamMessagesSent;
        private final Optional<Histogram> completedLatencySeconds;

        Factory(Configuration configuration) {
            CollectorRegistry collectorRegistry = configuration.getCollectorRegistry();
            this.rpcStarted = (Counter)rpcStartedBuilder.register(collectorRegistry);
            this.rpcCompleted = (Counter)rpcCompletedBuilder.register(collectorRegistry);
            this.streamMessagesReceived = (Counter)streamMessagesReceivedBuilder.register(collectorRegistry);
            this.streamMessagesSent = (Counter)streamMessagesSentBuilder.register(collectorRegistry);
            this.completedLatencySeconds = configuration.isIncludeLatencyHistograms() ? Optional.of((Histogram)completedLatencySecondsBuilder.buckets(configuration.getLatencyBuckets()).register(collectorRegistry)) : Optional.empty();
        }

        <R, S> ClientMetrics createMetricsForMethod(MethodDescriptor<R, S> methodDescriptor) {
            return new ClientMetrics(GrpcMethod.of(methodDescriptor), this.rpcStarted, this.rpcCompleted, this.streamMessagesReceived, this.streamMessagesSent, this.completedLatencySeconds);
        }
    }
}

