/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.bootstrap;

import io.camunda.zeebe.broker.bootstrap.AbstractBrokerStartupStep;
import io.camunda.zeebe.broker.bootstrap.BrokerStartupContext;
import io.camunda.zeebe.broker.transport.adminapi.AdminApiRequestHandler;
import io.camunda.zeebe.transport.impl.AtomixServerTransport;
import io.camunda.zeebe.util.sched.Actor;
import io.camunda.zeebe.util.sched.ActorSchedulingService;
import io.camunda.zeebe.util.sched.ConcurrencyControl;
import io.camunda.zeebe.util.sched.future.ActorFuture;

public class AdminApiServiceStep
extends AbstractBrokerStartupStep {
    public String getName() {
        return "Admin API";
    }

    @Override
    void startupInternal(BrokerStartupContext brokerStartupContext, ConcurrencyControl concurrencyControl, ActorFuture<BrokerStartupContext> startupFuture) {
        ActorSchedulingService schedulingService = brokerStartupContext.getActorSchedulingService();
        AtomixServerTransport transport = brokerStartupContext.getCommandApiServerTransport();
        AdminApiRequestHandler handler = new AdminApiRequestHandler(transport);
        concurrencyControl.runOnCompletion(schedulingService.submitActor((Actor)handler), this.proceed(() -> {
            if (brokerStartupContext.getAdminApiService() == null) {
                brokerStartupContext.setAdminApiService(handler);
            }
            startupFuture.complete((Object)brokerStartupContext);
        }, startupFuture));
    }

    @Override
    void shutdownInternal(BrokerStartupContext brokerShutdownContext, ConcurrencyControl concurrencyControl, ActorFuture<BrokerStartupContext> shutdownFuture) {
        AdminApiRequestHandler service = brokerShutdownContext.getAdminApiService();
        if (service == null) {
            shutdownFuture.complete((Object)brokerShutdownContext);
            return;
        }
        concurrencyControl.runOnCompletion(service.closeAsync(), this.proceed(() -> {
            brokerShutdownContext.setAdminApiService(null);
            shutdownFuture.complete((Object)brokerShutdownContext);
        }, shutdownFuture));
    }
}

