/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.bootstrap;

import io.atomix.cluster.messaging.ManagedMessagingService;
import io.camunda.zeebe.broker.PartitionListener;
import io.camunda.zeebe.broker.SpringBrokerBridge;
import io.camunda.zeebe.broker.bootstrap.BrokerStartupContext;
import io.camunda.zeebe.broker.clustering.ClusterServicesImpl;
import io.camunda.zeebe.broker.engine.impl.SubscriptionApiCommandMessageHandlerService;
import io.camunda.zeebe.broker.exporter.repo.ExporterRepository;
import io.camunda.zeebe.broker.partitioning.PartitionManagerImpl;
import io.camunda.zeebe.broker.system.EmbeddedGatewayService;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.management.BrokerAdminServiceImpl;
import io.camunda.zeebe.broker.system.management.LeaderManagementRequestHandler;
import io.camunda.zeebe.broker.system.monitoring.BrokerHealthCheckService;
import io.camunda.zeebe.broker.system.monitoring.DiskSpaceUsageListener;
import io.camunda.zeebe.broker.system.monitoring.DiskSpaceUsageMonitor;
import io.camunda.zeebe.broker.transport.adminapi.AdminApiRequestHandler;
import io.camunda.zeebe.broker.transport.commandapi.CommandApiServiceImpl;
import io.camunda.zeebe.protocol.impl.encoding.BrokerInfo;
import io.camunda.zeebe.transport.impl.AtomixServerTransport;
import io.camunda.zeebe.util.sched.ActorScheduler;
import io.camunda.zeebe.util.sched.ActorSchedulingService;
import io.camunda.zeebe.util.sched.ConcurrencyControl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class BrokerStartupContextImpl
implements BrokerStartupContext {
    private final BrokerInfo brokerInfo;
    private final BrokerCfg configuration;
    private final SpringBrokerBridge springBrokerBridge;
    private final ActorScheduler actorScheduler;
    private final BrokerHealthCheckService healthCheckService;
    private final ExporterRepository exporterRepository;
    private final List<PartitionListener> partitionListeners = new ArrayList<PartitionListener>();
    private ConcurrencyControl concurrencyControl;
    private DiskSpaceUsageMonitor diskSpaceUsageMonitor;
    private ClusterServicesImpl clusterServices;
    private AtomixServerTransport commandApiServerTransport;
    private ManagedMessagingService commandApiMessagingService;
    private CommandApiServiceImpl commandApiService;
    private AdminApiRequestHandler adminApiService;
    private SubscriptionApiCommandMessageHandlerService subscriptionApiService;
    private EmbeddedGatewayService embeddedGatewayService;
    private LeaderManagementRequestHandler leaderManagementRequestHandler;
    private PartitionManagerImpl partitionManager;
    private BrokerAdminServiceImpl brokerAdminService;

    public BrokerStartupContextImpl(BrokerInfo brokerInfo, BrokerCfg configuration, SpringBrokerBridge springBrokerBridge, ActorScheduler actorScheduler, BrokerHealthCheckService healthCheckService, ExporterRepository exporterRepository, List<PartitionListener> additionalPartitionListeners) {
        this.brokerInfo = Objects.requireNonNull(brokerInfo);
        this.configuration = Objects.requireNonNull(configuration);
        this.springBrokerBridge = Objects.requireNonNull(springBrokerBridge);
        this.actorScheduler = Objects.requireNonNull(actorScheduler);
        this.healthCheckService = Objects.requireNonNull(healthCheckService);
        this.exporterRepository = Objects.requireNonNull(exporterRepository);
        this.partitionListeners.addAll(additionalPartitionListeners);
    }

    @Override
    public BrokerInfo getBrokerInfo() {
        return this.brokerInfo;
    }

    @Override
    public BrokerCfg getBrokerConfiguration() {
        return this.configuration;
    }

    @Override
    public SpringBrokerBridge getSpringBrokerBridge() {
        return this.springBrokerBridge;
    }

    @Override
    public ActorSchedulingService getActorSchedulingService() {
        return this.actorScheduler;
    }

    @Override
    public ActorScheduler getActorScheduler() {
        return this.actorScheduler;
    }

    @Override
    public ConcurrencyControl getConcurrencyControl() {
        return this.concurrencyControl;
    }

    public void setConcurrencyControl(ConcurrencyControl concurrencyControl) {
        this.concurrencyControl = Objects.requireNonNull(concurrencyControl);
    }

    @Override
    public BrokerHealthCheckService getHealthCheckService() {
        return this.healthCheckService;
    }

    @Override
    public void addPartitionListener(PartitionListener listener) {
        this.partitionListeners.add(Objects.requireNonNull(listener));
    }

    @Override
    public void removePartitionListener(PartitionListener listener) {
        this.partitionListeners.remove(Objects.requireNonNull(listener));
    }

    @Override
    public List<PartitionListener> getPartitionListeners() {
        return Collections.unmodifiableList(this.partitionListeners);
    }

    @Override
    public ClusterServicesImpl getClusterServices() {
        return this.clusterServices;
    }

    @Override
    public void setClusterServices(ClusterServicesImpl clusterServices) {
        this.clusterServices = clusterServices;
    }

    @Override
    public void addDiskSpaceUsageListener(DiskSpaceUsageListener listener) {
        if (this.diskSpaceUsageMonitor != null) {
            this.diskSpaceUsageMonitor.addDiskUsageListener(listener);
        }
    }

    @Override
    public void removeDiskSpaceUsageListener(DiskSpaceUsageListener listener) {
        if (this.diskSpaceUsageMonitor != null) {
            this.diskSpaceUsageMonitor.removeDiskUsageListener(listener);
        }
    }

    @Override
    public CommandApiServiceImpl getCommandApiService() {
        return this.commandApiService;
    }

    @Override
    public void setCommandApiService(CommandApiServiceImpl commandApiService) {
        this.commandApiService = commandApiService;
    }

    @Override
    public AdminApiRequestHandler getAdminApiService() {
        return this.adminApiService;
    }

    @Override
    public void setAdminApiService(AdminApiRequestHandler adminApiService) {
        this.adminApiService = adminApiService;
    }

    @Override
    public AtomixServerTransport getCommandApiServerTransport() {
        return this.commandApiServerTransport;
    }

    @Override
    public void setCommandApiServerTransport(AtomixServerTransport commandApiServerTransport) {
        this.commandApiServerTransport = commandApiServerTransport;
    }

    @Override
    public ManagedMessagingService getApiMessagingService() {
        return this.commandApiMessagingService;
    }

    @Override
    public void setApiMessagingService(ManagedMessagingService commandApiMessagingService) {
        this.commandApiMessagingService = commandApiMessagingService;
    }

    @Override
    public SubscriptionApiCommandMessageHandlerService getSubscriptionApiService() {
        return this.subscriptionApiService;
    }

    @Override
    public void setSubscriptionApiService(SubscriptionApiCommandMessageHandlerService subscriptionApiService) {
        this.subscriptionApiService = subscriptionApiService;
    }

    @Override
    public EmbeddedGatewayService getEmbeddedGatewayService() {
        return this.embeddedGatewayService;
    }

    @Override
    public void setEmbeddedGatewayService(EmbeddedGatewayService embeddedGatewayService) {
        this.embeddedGatewayService = embeddedGatewayService;
    }

    @Override
    public DiskSpaceUsageMonitor getDiskSpaceUsageMonitor() {
        return this.diskSpaceUsageMonitor;
    }

    @Override
    public void setDiskSpaceUsageMonitor(DiskSpaceUsageMonitor diskSpaceUsageMonitor) {
        this.diskSpaceUsageMonitor = diskSpaceUsageMonitor;
    }

    @Override
    public LeaderManagementRequestHandler getLeaderManagementRequestHandler() {
        return this.leaderManagementRequestHandler;
    }

    @Override
    public void setLeaderManagementRequestHandler(LeaderManagementRequestHandler leaderManagementRequestHandler) {
        this.leaderManagementRequestHandler = leaderManagementRequestHandler;
    }

    @Override
    public ExporterRepository getExporterRepository() {
        return this.exporterRepository;
    }

    @Override
    public PartitionManagerImpl getPartitionManager() {
        return this.partitionManager;
    }

    @Override
    public void setPartitionManager(PartitionManagerImpl partitionManager) {
        this.partitionManager = partitionManager;
    }

    @Override
    public BrokerAdminServiceImpl getBrokerAdminService() {
        return this.brokerAdminService;
    }

    @Override
    public void setBrokerAdminService(BrokerAdminServiceImpl brokerAdminService) {
        this.brokerAdminService = brokerAdminService;
    }
}

