/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.partitioning;

import io.atomix.raft.partition.PartitionDistributor;
import io.atomix.raft.partition.RaftPartitionGroup;
import io.atomix.raft.partition.RoundRobinPartitionDistributor;
import io.atomix.raft.zeebe.EntryValidator;
import io.camunda.zeebe.broker.partitioning.distribution.FixedPartitionDistributor;
import io.camunda.zeebe.broker.partitioning.distribution.FixedPartitionDistributorBuilder;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.ClusterCfg;
import io.camunda.zeebe.broker.system.configuration.DataCfg;
import io.camunda.zeebe.broker.system.configuration.ExperimentalCfg;
import io.camunda.zeebe.broker.system.configuration.NetworkCfg;
import io.camunda.zeebe.broker.system.configuration.PartitioningCfg;
import io.camunda.zeebe.broker.system.configuration.partitioning.FixedPartitionCfg;
import io.camunda.zeebe.logstreams.impl.log.ZeebeEntryValidator;
import io.camunda.zeebe.snapshots.ReceivableSnapshotStoreFactory;
import io.camunda.zeebe.util.FileUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

final class RaftPartitionGroupFactory {
    RaftPartitionGroupFactory() {
    }

    RaftPartitionGroup buildRaftPartitionGroup(BrokerCfg configuration, ReceivableSnapshotStoreFactory snapshotStoreFactory) {
        DataCfg dataConfiguration = configuration.getData();
        String rootDirectory = dataConfiguration.getDirectory();
        Path rootPath = Paths.get(rootDirectory, new String[0]);
        try {
            FileUtil.ensureDirectoryExists((Path)rootPath);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create data directory", e);
        }
        Path raftDataDirectory = rootPath.resolve("raft-partition");
        try {
            FileUtil.ensureDirectoryExists((Path)raftDataDirectory);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create Raft data directory", e);
        }
        ClusterCfg clusterCfg = configuration.getCluster();
        ExperimentalCfg experimentalCfg = configuration.getExperimental();
        DataCfg dataCfg = configuration.getData();
        NetworkCfg networkCfg = configuration.getNetwork();
        PartitionDistributor partitionDistributor = this.buildPartitionDistributor(configuration.getExperimental().getPartitioning());
        RaftPartitionGroup.Builder partitionGroupBuilder = RaftPartitionGroup.builder((String)"raft-partition").withNumPartitions(clusterCfg.getPartitionsCount()).withPartitionSize(clusterCfg.getReplicationFactor()).withMembers(this.getRaftGroupMembers(clusterCfg)).withDataDirectory(raftDataDirectory.toFile()).withSnapshotStoreFactory(snapshotStoreFactory).withMaxAppendBatchSize((int)experimentalCfg.getMaxAppendBatchSizeInBytes()).withMaxAppendsPerFollower(experimentalCfg.getMaxAppendsPerFollower()).withEntryValidator((EntryValidator)new ZeebeEntryValidator()).withFlushExplicitly(!experimentalCfg.isDisableExplicitRaftFlush()).withFreeDiskSpace(dataCfg.getFreeDiskSpaceReplicationWatermark()).withJournalIndexDensity(dataCfg.getLogIndexDensity()).withPriorityElection(clusterCfg.getRaft().isEnablePriorityElection()).withPartitionDistributor(partitionDistributor).withElectionTimeout(clusterCfg.getElectionTimeout()).withHeartbeatInterval(clusterCfg.getHeartbeatInterval()).withRequestTimeout(experimentalCfg.getRaft().getRequestTimeout()).withMaxQuorumResponseTimeout(experimentalCfg.getRaft().getMaxQuorumResponseTimeout()).withMinStepDownFailureCount(experimentalCfg.getRaft().getMinStepDownFailureCount()).withPreferSnapshotReplicationThreshold(experimentalCfg.getRaft().getPreferSnapshotReplicationThreshold());
        int maxMessageSize = (int)networkCfg.getMaxMessageSizeInBytes();
        long segmentSize = dataCfg.getLogSegmentSizeInBytes();
        if (segmentSize < (long)maxMessageSize) {
            throw new IllegalArgumentException(String.format("Expected the raft segment size greater than the max message size of %s, but was %s.", maxMessageSize, segmentSize));
        }
        partitionGroupBuilder.withSegmentSize(segmentSize);
        return partitionGroupBuilder.build();
    }

    private List<String> getRaftGroupMembers(ClusterCfg clusterCfg) {
        int clusterSize = clusterCfg.getClusterSize();
        ArrayList<String> members = new ArrayList<String>();
        for (int i = 0; i < clusterSize; ++i) {
            members.add(Integer.toString(i));
        }
        return members;
    }

    private PartitionDistributor buildPartitionDistributor(PartitioningCfg config) {
        switch (config.getScheme()) {
            case FIXED: {
                return this.buildFixedPartitionDistributor(config);
            }
        }
        return new RoundRobinPartitionDistributor();
    }

    private FixedPartitionDistributor buildFixedPartitionDistributor(PartitioningCfg config) {
        FixedPartitionDistributorBuilder distributionBuilder = new FixedPartitionDistributorBuilder("raft-partition");
        for (FixedPartitionCfg partition : config.getFixed()) {
            for (FixedPartitionCfg.NodeCfg node : partition.getNodes()) {
                distributionBuilder.assignMember(partition.getPartitionId(), node.getNodeId(), node.getPriority());
            }
        }
        return distributionBuilder.build();
    }
}

