/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.management.deployment;

import io.atomix.cluster.messaging.ClusterEventService;
import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.engine.impl.DeploymentDistributorImpl;
import io.camunda.zeebe.broker.system.management.deployment.PushDeploymentRequest;
import io.camunda.zeebe.broker.system.management.deployment.PushDeploymentResponse;
import io.camunda.zeebe.clustering.management.MessageHeaderDecoder;
import io.camunda.zeebe.engine.processing.deployment.DeploymentResponder;
import io.camunda.zeebe.logstreams.log.LogStreamRecordWriter;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.protocol.impl.encoding.ErrorResponse;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.record.ErrorCode;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.util.buffer.BufferUtil;
import io.camunda.zeebe.util.buffer.BufferWriter;
import io.camunda.zeebe.util.sched.ActorControl;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.agrona.DirectBuffer;
import org.agrona.collections.Int2ObjectHashMap;
import org.agrona.concurrent.UnsafeBuffer;
import org.slf4j.Logger;

public final class PushDeploymentRequestHandler
implements Function<byte[], CompletableFuture<byte[]>>,
DeploymentResponder {
    private static final Logger LOG = Loggers.PROCESS_REPOSITORY_LOGGER;
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final RecordMetadata recordMetadata = new RecordMetadata();
    private final Int2ObjectHashMap<LogStreamRecordWriter> leaderPartitions;
    private final ActorControl actor;
    private final ClusterEventService eventService;

    public PushDeploymentRequestHandler(Int2ObjectHashMap<LogStreamRecordWriter> leaderPartitions, ActorControl actor, ClusterEventService eventService) {
        this.leaderPartitions = leaderPartitions;
        this.actor = actor;
        this.eventService = eventService;
    }

    @Override
    public CompletableFuture<byte[]> apply(byte[] bytes) {
        CompletableFuture<byte[]> responseFuture = new CompletableFuture<byte[]>();
        this.actor.call(() -> {
            UnsafeBuffer buffer = new UnsafeBuffer(bytes);
            boolean offset = false;
            int length = buffer.capacity();
            this.messageHeaderDecoder.wrap((DirectBuffer)buffer, 0);
            int schemaId = this.messageHeaderDecoder.schemaId();
            if (5 == schemaId) {
                int templateId = this.messageHeaderDecoder.templateId();
                if (2 == templateId) {
                    this.handleValidRequest(responseFuture, (DirectBuffer)buffer, 0, length);
                } else {
                    String errorMsg = String.format("Expected to have template id %d, but got %d.", 2, templateId);
                    responseFuture.completeExceptionally(new RuntimeException(errorMsg));
                }
            } else {
                String errorMsg = String.format("Expected to have schema id %d, but got %d.", 5, schemaId);
                responseFuture.completeExceptionally(new RuntimeException(errorMsg));
            }
        });
        return responseFuture;
    }

    public void sendDeploymentResponse(long deploymentKey, int partitionId) {
        PushDeploymentResponse deploymentResponse = new PushDeploymentResponse();
        deploymentResponse.deploymentKey(deploymentKey).partitionId(partitionId);
        String topic = DeploymentDistributorImpl.getDeploymentResponseTopic(deploymentKey, partitionId);
        this.eventService.broadcast(topic, (Object)deploymentResponse.toBytes());
        LOG.trace("Send deployment response on topic {} for partition {}", (Object)topic, (Object)partitionId);
    }

    private void handleValidRequest(CompletableFuture<byte[]> responseFuture, DirectBuffer buffer, int offset, int length) {
        PushDeploymentRequest pushDeploymentRequest = new PushDeploymentRequest();
        pushDeploymentRequest.wrap(buffer, offset, length);
        long deploymentKey = pushDeploymentRequest.deploymentKey();
        int partitionId = pushDeploymentRequest.partitionId();
        DirectBuffer deployment = pushDeploymentRequest.deployment();
        LogStreamRecordWriter logStreamWriter = (LogStreamRecordWriter)this.leaderPartitions.get(partitionId);
        if (logStreamWriter != null) {
            LOG.trace("Handling deployment {} for partition {} as leader", (Object)deploymentKey, (Object)partitionId);
            this.handlePushDeploymentRequest(responseFuture, deployment, deploymentKey, partitionId);
        } else {
            LOG.debug("Rejecting deployment {} for partition {} as not leader", (Object)deploymentKey, (Object)partitionId);
            this.sendNotLeaderRejection(responseFuture, partitionId);
        }
    }

    private void handlePushDeploymentRequest(CompletableFuture<byte[]> responseFuture, DirectBuffer deployment, long deploymentKey, int partitionId) {
        DeploymentRecord deploymentRecord = new DeploymentRecord();
        deploymentRecord.wrap(deployment);
        this.actor.runUntilDone(() -> {
            LogStreamRecordWriter logStream = (LogStreamRecordWriter)this.leaderPartitions.get(partitionId);
            if (logStream == null) {
                LOG.debug("Leader change on partition {}, ignore push deployment request", (Object)partitionId);
                this.actor.done();
                return;
            }
            boolean success = this.writeDistributeDeployment(logStream, deploymentKey, (UnpackedObject)deploymentRecord);
            if (success) {
                LOG.debug("Deployment DISTRIBUTE command for deployment {} was written on partition {}", (Object)deploymentKey, (Object)partitionId);
                this.actor.done();
                this.sendResponse(responseFuture, deploymentKey, partitionId);
            } else {
                this.actor.yieldThread();
            }
        });
    }

    private void sendResponse(CompletableFuture<byte[]> responseFuture, long deploymentKey, int partitionId) {
        PushDeploymentResponse pushResponse = new PushDeploymentResponse();
        pushResponse.deploymentKey(deploymentKey);
        pushResponse.partitionId(partitionId);
        responseFuture.complete(pushResponse.toBytes());
    }

    private void sendNotLeaderRejection(CompletableFuture<byte[]> responseFuture, int partitionId) {
        ErrorResponse notLeaderResponse = new ErrorResponse();
        notLeaderResponse.setErrorCode(ErrorCode.PARTITION_LEADER_MISMATCH).setErrorData(BufferUtil.wrapString((String)String.format("Not leader of partition %d", partitionId)));
        responseFuture.complete(notLeaderResponse.toBytes());
    }

    private boolean writeDistributeDeployment(LogStreamRecordWriter logStreamWriter, long key, UnpackedObject event) {
        RecordType recordType = RecordType.COMMAND;
        ValueType valueType = ValueType.DEPLOYMENT;
        DeploymentIntent intent = DeploymentIntent.DISTRIBUTE;
        logStreamWriter.reset();
        this.recordMetadata.reset().recordType(recordType).valueType(valueType).intent((Intent)intent);
        long position = logStreamWriter.key(key).metadataWriter((BufferWriter)this.recordMetadata).valueWriter((BufferWriter)event).tryWrite();
        return position > 0L;
    }
}

