/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.transport.commandapi;

import io.camunda.zeebe.broker.transport.ApiRequestHandler;
import io.camunda.zeebe.broker.transport.RequestReaderException;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import io.camunda.zeebe.protocol.impl.record.value.job.JobBatchRecord;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceCreationRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.impl.record.value.variable.VariableDocumentRecord;
import io.camunda.zeebe.protocol.record.ExecuteCommandRequestDecoder;
import io.camunda.zeebe.protocol.record.MessageHeaderDecoder;
import io.camunda.zeebe.protocol.record.ValueType;
import java.util.EnumMap;
import java.util.Map;
import org.agrona.DirectBuffer;

public class CommandApiRequestReader
implements ApiRequestHandler.RequestReader<ExecuteCommandRequestDecoder> {
    static final Map<ValueType, UnpackedObject> RECORDS_BY_TYPE = new EnumMap<ValueType, UnpackedObject>(ValueType.class);
    private UnpackedObject event;
    private final RecordMetadata eventMetadata = new RecordMetadata();
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final ExecuteCommandRequestDecoder commandRequestDecoder = new ExecuteCommandRequestDecoder();

    @Override
    public void reset() {
        if (this.event != null) {
            this.event.reset();
        }
        this.eventMetadata.reset();
    }

    @Override
    public ExecuteCommandRequestDecoder getMessageDecoder() {
        return this.commandRequestDecoder;
    }

    @Override
    public void wrap(DirectBuffer buffer, int offset, int length) {
        this.messageHeaderDecoder.wrap(buffer, offset);
        int templateId = this.messageHeaderDecoder.templateId();
        if (20 != templateId) {
            throw new RequestReaderException.InvalidTemplateException(this.messageHeaderDecoder.templateId(), templateId);
        }
        this.commandRequestDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
        int eventOffset = this.commandRequestDecoder.limit() + ExecuteCommandRequestDecoder.valueHeaderLength();
        int eventLength = this.commandRequestDecoder.valueLength();
        this.eventMetadata.protocolVersion(this.messageHeaderDecoder.version());
        this.event = RECORDS_BY_TYPE.get(this.commandRequestDecoder.valueType());
        if (this.event != null) {
            this.event.wrap(buffer, eventOffset, eventLength);
        }
    }

    public UnpackedObject event() {
        return this.event;
    }

    public RecordMetadata metadata() {
        return this.eventMetadata;
    }

    static {
        RECORDS_BY_TYPE.put(ValueType.DEPLOYMENT, (UnpackedObject)new DeploymentRecord());
        RECORDS_BY_TYPE.put(ValueType.JOB, (UnpackedObject)new JobRecord());
        RECORDS_BY_TYPE.put(ValueType.PROCESS_INSTANCE, (UnpackedObject)new ProcessInstanceRecord());
        RECORDS_BY_TYPE.put(ValueType.MESSAGE, (UnpackedObject)new MessageRecord());
        RECORDS_BY_TYPE.put(ValueType.JOB_BATCH, (UnpackedObject)new JobBatchRecord());
        RECORDS_BY_TYPE.put(ValueType.INCIDENT, (UnpackedObject)new IncidentRecord());
        RECORDS_BY_TYPE.put(ValueType.VARIABLE_DOCUMENT, (UnpackedObject)new VariableDocumentRecord());
        RECORDS_BY_TYPE.put(ValueType.PROCESS_INSTANCE_CREATION, (UnpackedObject)new ProcessInstanceCreationRecord());
    }
}

