/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging.impl;

import io.atomix.cluster.messaging.impl.HandlerRegistry;
import io.atomix.cluster.messaging.impl.ProtocolReply;
import io.atomix.cluster.messaging.impl.ProtocolRequest;
import io.atomix.cluster.messaging.impl.ServerConnection;
import io.camunda.zeebe.util.StringUtil;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractServerConnection
implements ServerConnection {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final HandlerRegistry handlers;

    AbstractServerConnection(HandlerRegistry handlers) {
        this.handlers = handlers;
    }

    @Override
    public void dispatch(ProtocolRequest message) {
        String subject = message.subject();
        BiConsumer<ProtocolRequest, ServerConnection> handler = this.handlers.get(subject);
        if (handler != null) {
            this.log.trace("Received message type {} from {}", (Object)subject, (Object)message.sender());
            handler.accept(message, this);
        } else {
            this.log.debug("No handler for message type {} from {}", (Object)subject, (Object)message.sender());
            byte[] subjectBytes = null;
            if (subject != null) {
                subjectBytes = StringUtil.getBytes((String)subject);
            }
            this.reply(message, ProtocolReply.Status.ERROR_NO_HANDLER, Optional.ofNullable(subjectBytes));
        }
    }
}

